<a id="mypy-boto3-cloudhsm"></a>

# mypy-boto3-cloudhsm

[![PyPI - mypy-boto3-cloudhsm](https://img.shields.io/pypi/v/mypy-boto3-cloudhsm.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudhsm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudhsm.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudhsm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-cloudhsm?color=blue)](https://pypistats.org/packages/mypy-boto3-cloudhsm)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CloudHSM 1.19.3](https://boto3.amazonaws.com/v1/documentation/api/1.19.3/reference/services/cloudhsm.html#CloudHSM)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-cloudhsm docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudhsm/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-cloudhsm](#mypy-boto3-cloudhsm)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `CloudHSM` service.

```bash
python -m pip install boto3-stubs[cloudhsm]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[cloudhsm]` in your environment:
  `python -m pip install 'boto3-stubs[cloudhsm]'`

Both type checking and auto-complete should work for `CloudHSM` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[cloudhsm]` in your environment:
  `python -m pip install 'boto3-stubs[cloudhsm]'`

Both type checking and auto-complete should work for `CloudHSM` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[cloudhsm]` in your environment:
  `python -m pip install 'boto3-stubs[cloudhsm]'`
- Run `mypy` as usual

Type checking should work for `CloudHSM` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[cloudhsm]` in your environment:
  `python -m pip install 'boto3-stubs[cloudhsm]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CloudHSM` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`CloudHSMClient` provides annotations for `boto3.client("cloudhsm")`.

```python
import boto3

from mypy_boto3_cloudhsm import CloudHSMClient

client: CloudHSMClient = boto3.client("cloudhsm")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudHSMClient = session.client("cloudhsm")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_cloudhsm.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_cloudhsm import CloudHSMClient
from mypy_boto3_cloudhsm.paginator import (
    ListHapgsPaginator,
    ListHsmsPaginator,
    ListLunaClientsPaginator,
)

client: CloudHSMClient = boto3.client("cloudhsm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_hapgs_paginator: ListHapgsPaginator = client.get_paginator("list_hapgs")
list_hsms_paginator: ListHsmsPaginator = client.get_paginator("list_hsms")
list_luna_clients_paginator: ListLunaClientsPaginator = client.get_paginator("list_luna_clients")
```

<a id="literals"></a>

### Literals

`mypy_boto3_cloudhsm.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_cloudhsm.literals import (
    ClientVersionType,
    CloudHsmObjectStateType,
    HsmStatusType,
    ListHapgsPaginatorName,
    ListHsmsPaginatorName,
    ListLunaClientsPaginatorName,
    SubscriptionTypeType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ClientVersionType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_cloudhsm.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_cloudhsm.type_defs import (
    AddTagsToResourceRequestRequestTypeDef,
    AddTagsToResourceResponseTypeDef,
    CreateHapgRequestRequestTypeDef,
    CreateHapgResponseTypeDef,
    CreateHsmRequestRequestTypeDef,
    CreateHsmResponseTypeDef,
    CreateLunaClientRequestRequestTypeDef,
    CreateLunaClientResponseTypeDef,
    DeleteHapgRequestRequestTypeDef,
    DeleteHapgResponseTypeDef,
    DeleteHsmRequestRequestTypeDef,
    DeleteHsmResponseTypeDef,
    DeleteLunaClientRequestRequestTypeDef,
    DeleteLunaClientResponseTypeDef,
    DescribeHapgRequestRequestTypeDef,
    DescribeHapgResponseTypeDef,
    DescribeHsmRequestRequestTypeDef,
    DescribeHsmResponseTypeDef,
    DescribeLunaClientRequestRequestTypeDef,
    DescribeLunaClientResponseTypeDef,
    GetConfigRequestRequestTypeDef,
    GetConfigResponseTypeDef,
    ListAvailableZonesResponseTypeDef,
    ListHapgsRequestRequestTypeDef,
    ListHapgsResponseTypeDef,
    ListHsmsRequestRequestTypeDef,
    ListHsmsResponseTypeDef,
    ListLunaClientsRequestRequestTypeDef,
    ListLunaClientsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ModifyHapgRequestRequestTypeDef,
    ModifyHapgResponseTypeDef,
    ModifyHsmRequestRequestTypeDef,
    ModifyHsmResponseTypeDef,
    ModifyLunaClientRequestRequestTypeDef,
    ModifyLunaClientResponseTypeDef,
    PaginatorConfigTypeDef,
    RemoveTagsFromResourceRequestRequestTypeDef,
    RemoveTagsFromResourceResponseTypeDef,
    ResponseMetadataTypeDef,
    TagTypeDef,
)

def get_structure() -> AddTagsToResourceRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-cloudhsm` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-cloudhsm docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudhsm/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
