# coding: utf-8

"""
    Automox Console API

    API for use with the Automox Console  # noqa: E501

    OpenAPI spec version: 2021-09-01
    Contact: support@automox.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PatchPolicyConfiguration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auto_patch': 'bool',
        'notify_user': 'bool',
        'missed_patch_window': 'bool',
        'auto_reboot': 'bool',
        'filters': 'list[str]',
        'device_filters_enabled': 'bool',
        'device_filters': 'DeviceFilters',
        'filter_type': 'str',
        'advanced_filter': 'list[PatchPolicyConfigurationAdvancedFilter]',
        'severity_filter': 'list[str]',
        'include_optional': 'bool',
        'notify_reboot_user': 'bool',
        'notify_deferred_reboot_user': 'bool',
        'custom_notification_patch_message': 'str',
        'custom_notification_patch_message_mac': 'str',
        'custom_notification_reboot_message': 'str',
        'custom_notification_reboot_message_mac': 'str',
        'custom_notification_max_delays': 'int',
        'custom_notification_deferment_periods': 'list[int]',
        'custom_pending_reboot_notification_message': 'str',
        'custom_pending_reboot_notification_message_mac': 'str',
        'custom_pending_reboot_notification_max_delays': 'int',
        'custom_pending_reboot_notification_deferment_periods': 'list[int]',
        'notify_user_message_timeout': 'int',
        'notify_deferred_reboot_user_message_timeout': 'int',
        'notify_user_auto_deferral_enabled': 'bool',
        'notify_deferred_reboot_user_auto_deferral_enabled': 'bool'
    }

    attribute_map = {
        'auto_patch': 'auto_patch',
        'notify_user': 'notify_user',
        'missed_patch_window': 'missed_patch_window',
        'auto_reboot': 'auto_reboot',
        'filters': 'filters',
        'device_filters_enabled': 'device_filters_enabled',
        'device_filters': 'device_filters',
        'filter_type': 'filter_type',
        'advanced_filter': 'advanced_filter',
        'severity_filter': 'severity_filter',
        'include_optional': 'include_optional',
        'notify_reboot_user': 'notify_reboot_user',
        'notify_deferred_reboot_user': 'notify_deferred_reboot_user',
        'custom_notification_patch_message': 'custom_notification_patch_message',
        'custom_notification_patch_message_mac': 'custom_notification_patch_message_mac',
        'custom_notification_reboot_message': 'custom_notification_reboot_message',
        'custom_notification_reboot_message_mac': 'custom_notification_reboot_message_mac',
        'custom_notification_max_delays': 'custom_notification_max_delays',
        'custom_notification_deferment_periods': 'custom_notification_deferment_periods',
        'custom_pending_reboot_notification_message': 'custom_pending_reboot_notification_message',
        'custom_pending_reboot_notification_message_mac': 'custom_pending_reboot_notification_message_mac',
        'custom_pending_reboot_notification_max_delays': 'custom_pending_reboot_notification_max_delays',
        'custom_pending_reboot_notification_deferment_periods': 'custom_pending_reboot_notification_deferment_periods',
        'notify_user_message_timeout': 'notify_user_message_timeout',
        'notify_deferred_reboot_user_message_timeout': 'notify_deferred_reboot_user_message_timeout',
        'notify_user_auto_deferral_enabled': 'notify_user_auto_deferral_enabled',
        'notify_deferred_reboot_user_auto_deferral_enabled': 'notify_deferred_reboot_user_auto_deferral_enabled'
    }

    def __init__(self, auto_patch=None, notify_user=None, missed_patch_window=None, auto_reboot=None, filters=None, device_filters_enabled=None, device_filters=None, filter_type=None, advanced_filter=None, severity_filter=None, include_optional=False, notify_reboot_user=None, notify_deferred_reboot_user=None, custom_notification_patch_message=None, custom_notification_patch_message_mac=None, custom_notification_reboot_message=None, custom_notification_reboot_message_mac=None, custom_notification_max_delays=0, custom_notification_deferment_periods=None, custom_pending_reboot_notification_message=None, custom_pending_reboot_notification_message_mac=None, custom_pending_reboot_notification_max_delays=0, custom_pending_reboot_notification_deferment_periods=None, notify_user_message_timeout=15, notify_deferred_reboot_user_message_timeout=15, notify_user_auto_deferral_enabled=False, notify_deferred_reboot_user_auto_deferral_enabled=False):  # noqa: E501
        """PatchPolicyConfiguration - a model defined in Swagger"""  # noqa: E501
        self._auto_patch = None
        self._notify_user = None
        self._missed_patch_window = None
        self._auto_reboot = None
        self._filters = None
        self._device_filters_enabled = None
        self._device_filters = None
        self._filter_type = None
        self._advanced_filter = None
        self._severity_filter = None
        self._include_optional = None
        self._notify_reboot_user = None
        self._notify_deferred_reboot_user = None
        self._custom_notification_patch_message = None
        self._custom_notification_patch_message_mac = None
        self._custom_notification_reboot_message = None
        self._custom_notification_reboot_message_mac = None
        self._custom_notification_max_delays = None
        self._custom_notification_deferment_periods = None
        self._custom_pending_reboot_notification_message = None
        self._custom_pending_reboot_notification_message_mac = None
        self._custom_pending_reboot_notification_max_delays = None
        self._custom_pending_reboot_notification_deferment_periods = None
        self._notify_user_message_timeout = None
        self._notify_deferred_reboot_user_message_timeout = None
        self._notify_user_auto_deferral_enabled = None
        self._notify_deferred_reboot_user_auto_deferral_enabled = None
        self.discriminator = None
        self.auto_patch = auto_patch
        self.notify_user = notify_user
        if missed_patch_window is not None:
            self.missed_patch_window = missed_patch_window
        self.auto_reboot = auto_reboot
        if filters is not None:
            self.filters = filters
        if device_filters_enabled is not None:
            self.device_filters_enabled = device_filters_enabled
        if device_filters is not None:
            self.device_filters = device_filters
        if filter_type is not None:
            self.filter_type = filter_type
        if advanced_filter is not None:
            self.advanced_filter = advanced_filter
        if severity_filter is not None:
            self.severity_filter = severity_filter
        if include_optional is not None:
            self.include_optional = include_optional
        if notify_reboot_user is not None:
            self.notify_reboot_user = notify_reboot_user
        if notify_deferred_reboot_user is not None:
            self.notify_deferred_reboot_user = notify_deferred_reboot_user
        if custom_notification_patch_message is not None:
            self.custom_notification_patch_message = custom_notification_patch_message
        if custom_notification_patch_message_mac is not None:
            self.custom_notification_patch_message_mac = custom_notification_patch_message_mac
        if custom_notification_reboot_message is not None:
            self.custom_notification_reboot_message = custom_notification_reboot_message
        if custom_notification_reboot_message_mac is not None:
            self.custom_notification_reboot_message_mac = custom_notification_reboot_message_mac
        if custom_notification_max_delays is not None:
            self.custom_notification_max_delays = custom_notification_max_delays
        if custom_notification_deferment_periods is not None:
            self.custom_notification_deferment_periods = custom_notification_deferment_periods
        if custom_pending_reboot_notification_message is not None:
            self.custom_pending_reboot_notification_message = custom_pending_reboot_notification_message
        if custom_pending_reboot_notification_message_mac is not None:
            self.custom_pending_reboot_notification_message_mac = custom_pending_reboot_notification_message_mac
        if custom_pending_reboot_notification_max_delays is not None:
            self.custom_pending_reboot_notification_max_delays = custom_pending_reboot_notification_max_delays
        if custom_pending_reboot_notification_deferment_periods is not None:
            self.custom_pending_reboot_notification_deferment_periods = custom_pending_reboot_notification_deferment_periods
        if notify_user_message_timeout is not None:
            self.notify_user_message_timeout = notify_user_message_timeout
        if notify_deferred_reboot_user_message_timeout is not None:
            self.notify_deferred_reboot_user_message_timeout = notify_deferred_reboot_user_message_timeout
        if notify_user_auto_deferral_enabled is not None:
            self.notify_user_auto_deferral_enabled = notify_user_auto_deferral_enabled
        if notify_deferred_reboot_user_auto_deferral_enabled is not None:
            self.notify_deferred_reboot_user_auto_deferral_enabled = notify_deferred_reboot_user_auto_deferral_enabled

    @property
    def auto_patch(self):
        """Gets the auto_patch of this PatchPolicyConfiguration.  # noqa: E501

        Enable or Disable automatic execution of the policy.  # noqa: E501

        :return: The auto_patch of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._auto_patch

    @auto_patch.setter
    def auto_patch(self, auto_patch):
        """Sets the auto_patch of this PatchPolicyConfiguration.

        Enable or Disable automatic execution of the policy.  # noqa: E501

        :param auto_patch: The auto_patch of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """
        if auto_patch is None:
            raise ValueError("Invalid value for `auto_patch`, must not be `None`")  # noqa: E501

        self._auto_patch = auto_patch

    @property
    def notify_user(self):
        """Gets the notify_user of this PatchPolicyConfiguration.  # noqa: E501

        Display notification 15 minutes before patching.  # noqa: E501

        :return: The notify_user of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._notify_user

    @notify_user.setter
    def notify_user(self, notify_user):
        """Sets the notify_user of this PatchPolicyConfiguration.

        Display notification 15 minutes before patching.  # noqa: E501

        :param notify_user: The notify_user of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """
        if notify_user is None:
            raise ValueError("Invalid value for `notify_user`, must not be `None`")  # noqa: E501

        self._notify_user = notify_user

    @property
    def missed_patch_window(self):
        """Gets the missed_patch_window of this PatchPolicyConfiguration.  # noqa: E501

        Enable or Disable Missed Patch Window setting.  # noqa: E501

        :return: The missed_patch_window of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._missed_patch_window

    @missed_patch_window.setter
    def missed_patch_window(self, missed_patch_window):
        """Sets the missed_patch_window of this PatchPolicyConfiguration.

        Enable or Disable Missed Patch Window setting.  # noqa: E501

        :param missed_patch_window: The missed_patch_window of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """

        self._missed_patch_window = missed_patch_window

    @property
    def auto_reboot(self):
        """Gets the auto_reboot of this PatchPolicyConfiguration.  # noqa: E501

        Enable or Disable automatic reboots following policy execution.  # noqa: E501

        :return: The auto_reboot of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._auto_reboot

    @auto_reboot.setter
    def auto_reboot(self, auto_reboot):
        """Sets the auto_reboot of this PatchPolicyConfiguration.

        Enable or Disable automatic reboots following policy execution.  # noqa: E501

        :param auto_reboot: The auto_reboot of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """
        if auto_reboot is None:
            raise ValueError("Invalid value for `auto_reboot`, must not be `None`")  # noqa: E501

        self._auto_reboot = auto_reboot

    @property
    def filters(self):
        """Gets the filters of this PatchPolicyConfiguration.  # noqa: E501

        Use only with `filter_type` of `exclude` or `include`. Use `*` for wildcard.  # noqa: E501

        :return: The filters of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this PatchPolicyConfiguration.

        Use only with `filter_type` of `exclude` or `include`. Use `*` for wildcard.  # noqa: E501

        :param filters: The filters of this PatchPolicyConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._filters = filters

    @property
    def device_filters_enabled(self):
        """Gets the device_filters_enabled of this PatchPolicyConfiguration.  # noqa: E501

        Enable or disable Device Filters.  # noqa: E501

        :return: The device_filters_enabled of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._device_filters_enabled

    @device_filters_enabled.setter
    def device_filters_enabled(self, device_filters_enabled):
        """Sets the device_filters_enabled of this PatchPolicyConfiguration.

        Enable or disable Device Filters.  # noqa: E501

        :param device_filters_enabled: The device_filters_enabled of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """

        self._device_filters_enabled = device_filters_enabled

    @property
    def device_filters(self):
        """Gets the device_filters of this PatchPolicyConfiguration.  # noqa: E501


        :return: The device_filters of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: DeviceFilters
        """
        return self._device_filters

    @device_filters.setter
    def device_filters(self, device_filters):
        """Sets the device_filters of this PatchPolicyConfiguration.


        :param device_filters: The device_filters of this PatchPolicyConfiguration.  # noqa: E501
        :type: DeviceFilters
        """

        self._device_filters = device_filters

    @property
    def filter_type(self):
        """Gets the filter_type of this PatchPolicyConfiguration.  # noqa: E501

        Use only with `patch_rule` of `filter`  # noqa: E501

        :return: The filter_type of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._filter_type

    @filter_type.setter
    def filter_type(self, filter_type):
        """Sets the filter_type of this PatchPolicyConfiguration.

        Use only with `patch_rule` of `filter`  # noqa: E501

        :param filter_type: The filter_type of this PatchPolicyConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["exclude", "include", "severity"]  # noqa: E501
        if filter_type not in allowed_values:
            raise ValueError(
                "Invalid value for `filter_type` ({0}), must be one of {1}"  # noqa: E501
                .format(filter_type, allowed_values)
            )

        self._filter_type = filter_type

    @property
    def advanced_filter(self):
        """Gets the advanced_filter of this PatchPolicyConfiguration.  # noqa: E501

        Object array. Include one object per advanced filter line. See [Policy and Device Filters, and Scheduling - Advanced Filters](/developer-portal/policy_filters_schedule/#advanced-filters)  # noqa: E501

        :return: The advanced_filter of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: list[PatchPolicyConfigurationAdvancedFilter]
        """
        return self._advanced_filter

    @advanced_filter.setter
    def advanced_filter(self, advanced_filter):
        """Sets the advanced_filter of this PatchPolicyConfiguration.

        Object array. Include one object per advanced filter line. See [Policy and Device Filters, and Scheduling - Advanced Filters](/developer-portal/policy_filters_schedule/#advanced-filters)  # noqa: E501

        :param advanced_filter: The advanced_filter of this PatchPolicyConfiguration.  # noqa: E501
        :type: list[PatchPolicyConfigurationAdvancedFilter]
        """

        self._advanced_filter = advanced_filter

    @property
    def severity_filter(self):
        """Gets the severity_filter of this PatchPolicyConfiguration.  # noqa: E501

        String array. Use only with `filter_type` of `severity`. Defines severity ratings to include in patching. Format: [\"low\",\"medium\",\"high\",\"critical\",\"none\",\"unknown\"]  # noqa: E501

        :return: The severity_filter of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._severity_filter

    @severity_filter.setter
    def severity_filter(self, severity_filter):
        """Sets the severity_filter of this PatchPolicyConfiguration.

        String array. Use only with `filter_type` of `severity`. Defines severity ratings to include in patching. Format: [\"low\",\"medium\",\"high\",\"critical\",\"none\",\"unknown\"]  # noqa: E501

        :param severity_filter: The severity_filter of this PatchPolicyConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._severity_filter = severity_filter

    @property
    def include_optional(self):
        """Gets the include_optional of this PatchPolicyConfiguration.  # noqa: E501

        Enable or disable inclusion of optional Windows patches for this policy **NOTE:** Will default to false if not included.  # noqa: E501

        :return: The include_optional of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._include_optional

    @include_optional.setter
    def include_optional(self, include_optional):
        """Sets the include_optional of this PatchPolicyConfiguration.

        Enable or disable inclusion of optional Windows patches for this policy **NOTE:** Will default to false if not included.  # noqa: E501

        :param include_optional: The include_optional of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """

        self._include_optional = include_optional

    @property
    def notify_reboot_user(self):
        """Gets the notify_reboot_user of this PatchPolicyConfiguration.  # noqa: E501

        Display modified notification 15 minutes before patching. This message should inform the user that a reboot will follow patching actions.  # noqa: E501

        :return: The notify_reboot_user of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._notify_reboot_user

    @notify_reboot_user.setter
    def notify_reboot_user(self, notify_reboot_user):
        """Sets the notify_reboot_user of this PatchPolicyConfiguration.

        Display modified notification 15 minutes before patching. This message should inform the user that a reboot will follow patching actions.  # noqa: E501

        :param notify_reboot_user: The notify_reboot_user of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """

        self._notify_reboot_user = notify_reboot_user

    @property
    def notify_deferred_reboot_user(self):
        """Gets the notify_deferred_reboot_user of this PatchPolicyConfiguration.  # noqa: E501

        If `true`, this shows a post-install reboot notification message, if `notify_reboot_deferred` is also `true`. If `notify_reboot_deferred` is `false` or `null`, this will sync with the existing `notify_reboot_user` parameter.  # noqa: E501

        :return: The notify_deferred_reboot_user of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._notify_deferred_reboot_user

    @notify_deferred_reboot_user.setter
    def notify_deferred_reboot_user(self, notify_deferred_reboot_user):
        """Sets the notify_deferred_reboot_user of this PatchPolicyConfiguration.

        If `true`, this shows a post-install reboot notification message, if `notify_reboot_deferred` is also `true`. If `notify_reboot_deferred` is `false` or `null`, this will sync with the existing `notify_reboot_user` parameter.  # noqa: E501

        :param notify_deferred_reboot_user: The notify_deferred_reboot_user of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """

        self._notify_deferred_reboot_user = notify_deferred_reboot_user

    @property
    def custom_notification_patch_message(self):
        """Gets the custom_notification_patch_message of this PatchPolicyConfiguration.  # noqa: E501

        Message to display before a non-rebooting patch policy executes on a Windows device. Maximum 125 characters  # noqa: E501

        :return: The custom_notification_patch_message of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._custom_notification_patch_message

    @custom_notification_patch_message.setter
    def custom_notification_patch_message(self, custom_notification_patch_message):
        """Sets the custom_notification_patch_message of this PatchPolicyConfiguration.

        Message to display before a non-rebooting patch policy executes on a Windows device. Maximum 125 characters  # noqa: E501

        :param custom_notification_patch_message: The custom_notification_patch_message of this PatchPolicyConfiguration.  # noqa: E501
        :type: str
        """

        self._custom_notification_patch_message = custom_notification_patch_message

    @property
    def custom_notification_patch_message_mac(self):
        """Gets the custom_notification_patch_message_mac of this PatchPolicyConfiguration.  # noqa: E501

        Message to display before a non-rebooting patch policy executes on a macOS device. Maximum 70 characters  # noqa: E501

        :return: The custom_notification_patch_message_mac of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._custom_notification_patch_message_mac

    @custom_notification_patch_message_mac.setter
    def custom_notification_patch_message_mac(self, custom_notification_patch_message_mac):
        """Sets the custom_notification_patch_message_mac of this PatchPolicyConfiguration.

        Message to display before a non-rebooting patch policy executes on a macOS device. Maximum 70 characters  # noqa: E501

        :param custom_notification_patch_message_mac: The custom_notification_patch_message_mac of this PatchPolicyConfiguration.  # noqa: E501
        :type: str
        """

        self._custom_notification_patch_message_mac = custom_notification_patch_message_mac

    @property
    def custom_notification_reboot_message(self):
        """Gets the custom_notification_reboot_message of this PatchPolicyConfiguration.  # noqa: E501

        Message to display before a rebooting patch policy executes on a Windows device. Reboot will follow patching actions. Maximum 125 characters  # noqa: E501

        :return: The custom_notification_reboot_message of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._custom_notification_reboot_message

    @custom_notification_reboot_message.setter
    def custom_notification_reboot_message(self, custom_notification_reboot_message):
        """Sets the custom_notification_reboot_message of this PatchPolicyConfiguration.

        Message to display before a rebooting patch policy executes on a Windows device. Reboot will follow patching actions. Maximum 125 characters  # noqa: E501

        :param custom_notification_reboot_message: The custom_notification_reboot_message of this PatchPolicyConfiguration.  # noqa: E501
        :type: str
        """

        self._custom_notification_reboot_message = custom_notification_reboot_message

    @property
    def custom_notification_reboot_message_mac(self):
        """Gets the custom_notification_reboot_message_mac of this PatchPolicyConfiguration.  # noqa: E501

        Message to display before a rebooting patch policy executes on a macOS device. Reboot will follow patching actions. Maximum 70 characters  # noqa: E501

        :return: The custom_notification_reboot_message_mac of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._custom_notification_reboot_message_mac

    @custom_notification_reboot_message_mac.setter
    def custom_notification_reboot_message_mac(self, custom_notification_reboot_message_mac):
        """Sets the custom_notification_reboot_message_mac of this PatchPolicyConfiguration.

        Message to display before a rebooting patch policy executes on a macOS device. Reboot will follow patching actions. Maximum 70 characters  # noqa: E501

        :param custom_notification_reboot_message_mac: The custom_notification_reboot_message_mac of this PatchPolicyConfiguration.  # noqa: E501
        :type: str
        """

        self._custom_notification_reboot_message_mac = custom_notification_reboot_message_mac

    @property
    def custom_notification_max_delays(self):
        """Gets the custom_notification_max_delays of this PatchPolicyConfiguration.  # noqa: E501

        Maximum number of times a user is allowed to defer the reboot. The default is 0.  # noqa: E501

        :return: The custom_notification_max_delays of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._custom_notification_max_delays

    @custom_notification_max_delays.setter
    def custom_notification_max_delays(self, custom_notification_max_delays):
        """Sets the custom_notification_max_delays of this PatchPolicyConfiguration.

        Maximum number of times a user is allowed to defer the reboot. The default is 0.  # noqa: E501

        :param custom_notification_max_delays: The custom_notification_max_delays of this PatchPolicyConfiguration.  # noqa: E501
        :type: int
        """

        self._custom_notification_max_delays = custom_notification_max_delays

    @property
    def custom_notification_deferment_periods(self):
        """Gets the custom_notification_deferment_periods of this PatchPolicyConfiguration.  # noqa: E501

        Integer array: Deferral time periods (hours) that users can choose from. Include up to 3. All 3 must be distinct with a maximum of 24. Default values: 1, 4, 8  # noqa: E501

        :return: The custom_notification_deferment_periods of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: list[int]
        """
        return self._custom_notification_deferment_periods

    @custom_notification_deferment_periods.setter
    def custom_notification_deferment_periods(self, custom_notification_deferment_periods):
        """Sets the custom_notification_deferment_periods of this PatchPolicyConfiguration.

        Integer array: Deferral time periods (hours) that users can choose from. Include up to 3. All 3 must be distinct with a maximum of 24. Default values: 1, 4, 8  # noqa: E501

        :param custom_notification_deferment_periods: The custom_notification_deferment_periods of this PatchPolicyConfiguration.  # noqa: E501
        :type: list[int]
        """

        self._custom_notification_deferment_periods = custom_notification_deferment_periods

    @property
    def custom_pending_reboot_notification_message(self):
        """Gets the custom_pending_reboot_notification_message of this PatchPolicyConfiguration.  # noqa: E501

        Custom reboot message.  # noqa: E501

        :return: The custom_pending_reboot_notification_message of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._custom_pending_reboot_notification_message

    @custom_pending_reboot_notification_message.setter
    def custom_pending_reboot_notification_message(self, custom_pending_reboot_notification_message):
        """Sets the custom_pending_reboot_notification_message of this PatchPolicyConfiguration.

        Custom reboot message.  # noqa: E501

        :param custom_pending_reboot_notification_message: The custom_pending_reboot_notification_message of this PatchPolicyConfiguration.  # noqa: E501
        :type: str
        """

        self._custom_pending_reboot_notification_message = custom_pending_reboot_notification_message

    @property
    def custom_pending_reboot_notification_message_mac(self):
        """Gets the custom_pending_reboot_notification_message_mac of this PatchPolicyConfiguration.  # noqa: E501

        The custom reboot message for macOS, which overrides `custom_pending_reboot_notification_message` string, if provided.  # noqa: E501

        :return: The custom_pending_reboot_notification_message_mac of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._custom_pending_reboot_notification_message_mac

    @custom_pending_reboot_notification_message_mac.setter
    def custom_pending_reboot_notification_message_mac(self, custom_pending_reboot_notification_message_mac):
        """Sets the custom_pending_reboot_notification_message_mac of this PatchPolicyConfiguration.

        The custom reboot message for macOS, which overrides `custom_pending_reboot_notification_message` string, if provided.  # noqa: E501

        :param custom_pending_reboot_notification_message_mac: The custom_pending_reboot_notification_message_mac of this PatchPolicyConfiguration.  # noqa: E501
        :type: str
        """

        self._custom_pending_reboot_notification_message_mac = custom_pending_reboot_notification_message_mac

    @property
    def custom_pending_reboot_notification_max_delays(self):
        """Gets the custom_pending_reboot_notification_max_delays of this PatchPolicyConfiguration.  # noqa: E501

        Maximum number of times a user is allowed to defer the reboot. The default is 0.  # noqa: E501

        :return: The custom_pending_reboot_notification_max_delays of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._custom_pending_reboot_notification_max_delays

    @custom_pending_reboot_notification_max_delays.setter
    def custom_pending_reboot_notification_max_delays(self, custom_pending_reboot_notification_max_delays):
        """Sets the custom_pending_reboot_notification_max_delays of this PatchPolicyConfiguration.

        Maximum number of times a user is allowed to defer the reboot. The default is 0.  # noqa: E501

        :param custom_pending_reboot_notification_max_delays: The custom_pending_reboot_notification_max_delays of this PatchPolicyConfiguration.  # noqa: E501
        :type: int
        """

        self._custom_pending_reboot_notification_max_delays = custom_pending_reboot_notification_max_delays

    @property
    def custom_pending_reboot_notification_deferment_periods(self):
        """Gets the custom_pending_reboot_notification_deferment_periods of this PatchPolicyConfiguration.  # noqa: E501

        The time period options available to defer a reboot for each deferral selection. Default values: 1, 4, 8  # noqa: E501

        :return: The custom_pending_reboot_notification_deferment_periods of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: list[int]
        """
        return self._custom_pending_reboot_notification_deferment_periods

    @custom_pending_reboot_notification_deferment_periods.setter
    def custom_pending_reboot_notification_deferment_periods(self, custom_pending_reboot_notification_deferment_periods):
        """Sets the custom_pending_reboot_notification_deferment_periods of this PatchPolicyConfiguration.

        The time period options available to defer a reboot for each deferral selection. Default values: 1, 4, 8  # noqa: E501

        :param custom_pending_reboot_notification_deferment_periods: The custom_pending_reboot_notification_deferment_periods of this PatchPolicyConfiguration.  # noqa: E501
        :type: list[int]
        """

        self._custom_pending_reboot_notification_deferment_periods = custom_pending_reboot_notification_deferment_periods

    @property
    def notify_user_message_timeout(self):
        """Gets the notify_user_message_timeout of this PatchPolicyConfiguration.  # noqa: E501

        The amount of time a patch notification appears before timing out and closing. Min: 15 min. Max: 480 min. Default is 15 minutes.  # noqa: E501

        :return: The notify_user_message_timeout of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._notify_user_message_timeout

    @notify_user_message_timeout.setter
    def notify_user_message_timeout(self, notify_user_message_timeout):
        """Sets the notify_user_message_timeout of this PatchPolicyConfiguration.

        The amount of time a patch notification appears before timing out and closing. Min: 15 min. Max: 480 min. Default is 15 minutes.  # noqa: E501

        :param notify_user_message_timeout: The notify_user_message_timeout of this PatchPolicyConfiguration.  # noqa: E501
        :type: int
        """

        self._notify_user_message_timeout = notify_user_message_timeout

    @property
    def notify_deferred_reboot_user_message_timeout(self):
        """Gets the notify_deferred_reboot_user_message_timeout of this PatchPolicyConfiguration.  # noqa: E501

        The amount of time a deferrable reboot notification message appears before timing out and closing. Min: 15 min. Max: 480 min. Default is 15 minutes.  # noqa: E501

        :return: The notify_deferred_reboot_user_message_timeout of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._notify_deferred_reboot_user_message_timeout

    @notify_deferred_reboot_user_message_timeout.setter
    def notify_deferred_reboot_user_message_timeout(self, notify_deferred_reboot_user_message_timeout):
        """Sets the notify_deferred_reboot_user_message_timeout of this PatchPolicyConfiguration.

        The amount of time a deferrable reboot notification message appears before timing out and closing. Min: 15 min. Max: 480 min. Default is 15 minutes.  # noqa: E501

        :param notify_deferred_reboot_user_message_timeout: The notify_deferred_reboot_user_message_timeout of this PatchPolicyConfiguration.  # noqa: E501
        :type: int
        """

        self._notify_deferred_reboot_user_message_timeout = notify_deferred_reboot_user_message_timeout

    @property
    def notify_user_auto_deferral_enabled(self):
        """Gets the notify_user_auto_deferral_enabled of this PatchPolicyConfiguration.  # noqa: E501

        If a patch notification times out, apply the highest configured patch deferral.  # noqa: E501

        :return: The notify_user_auto_deferral_enabled of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._notify_user_auto_deferral_enabled

    @notify_user_auto_deferral_enabled.setter
    def notify_user_auto_deferral_enabled(self, notify_user_auto_deferral_enabled):
        """Sets the notify_user_auto_deferral_enabled of this PatchPolicyConfiguration.

        If a patch notification times out, apply the highest configured patch deferral.  # noqa: E501

        :param notify_user_auto_deferral_enabled: The notify_user_auto_deferral_enabled of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """

        self._notify_user_auto_deferral_enabled = notify_user_auto_deferral_enabled

    @property
    def notify_deferred_reboot_user_auto_deferral_enabled(self):
        """Gets the notify_deferred_reboot_user_auto_deferral_enabled of this PatchPolicyConfiguration.  # noqa: E501

        If a reboot notification times out, apply the highest configured reboot deferral.  # noqa: E501

        :return: The notify_deferred_reboot_user_auto_deferral_enabled of this PatchPolicyConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._notify_deferred_reboot_user_auto_deferral_enabled

    @notify_deferred_reboot_user_auto_deferral_enabled.setter
    def notify_deferred_reboot_user_auto_deferral_enabled(self, notify_deferred_reboot_user_auto_deferral_enabled):
        """Sets the notify_deferred_reboot_user_auto_deferral_enabled of this PatchPolicyConfiguration.

        If a reboot notification times out, apply the highest configured reboot deferral.  # noqa: E501

        :param notify_deferred_reboot_user_auto_deferral_enabled: The notify_deferred_reboot_user_auto_deferral_enabled of this PatchPolicyConfiguration.  # noqa: E501
        :type: bool
        """

        self._notify_deferred_reboot_user_auto_deferral_enabled = notify_deferred_reboot_user_auto_deferral_enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PatchPolicyConfiguration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PatchPolicyConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
