#   Copyright 2020 Red Hat, Inc.
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#
"""Default paths for validation playbook directory,
validation groups definitions and validation logs
are defined here.

These paths are used in an absence of user defined overrides,
or as a fallback, when custom locations fail.
"""

import os

# @matbu backward compatibility for stable/train
try:
    from pathlib import Path
except ImportError:
    from pathlib2 import Path

DEFAULT_VALIDATIONS_BASEDIR = '/usr/share/ansible'

ANSIBLE_VALIDATION_DIR = os.path.join(
    DEFAULT_VALIDATIONS_BASEDIR,
    'validation-playbooks')

ANSIBLE_ROLES_DIR = Path.joinpath(Path(DEFAULT_VALIDATIONS_BASEDIR),
                                  'roles')

VALIDATION_GROUPS_INFO = os.path.join(
    DEFAULT_VALIDATIONS_BASEDIR,
    'groups.yaml')

# NOTE(fressi) The HOME folder environment variable may be undefined.
VALIDATIONS_LOG_BASEDIR = os.path.expanduser('~/validations')

VALIDATION_ANSIBLE_ARTIFACT_PATH = os.path.join(
    VALIDATIONS_LOG_BASEDIR,
    'artifacts')

ANSIBLE_RUNNER_CONFIG_PARAMETERS = ['verbosity', 'extravars', 'fact_cache',
                                    'fact_cache_type', 'inventory', 'playbook',
                                    'project_dir', 'quiet', 'rotate_artifacts']

# Community Validations paths
COMMUNITY_VALIDATIONS_BASEDIR = Path.home().joinpath('community-validations')

COMMUNITY_ROLES_DIR = Path.joinpath(COMMUNITY_VALIDATIONS_BASEDIR, 'roles')

COMMUNITY_PLAYBOOKS_DIR = Path.joinpath(
    COMMUNITY_VALIDATIONS_BASEDIR, 'playbooks')

COMMUNITY_LIBRARY_DIR = Path.joinpath(
    COMMUNITY_VALIDATIONS_BASEDIR, 'library')

COMMUNITY_LOOKUP_DIR = Path.joinpath(
    COMMUNITY_VALIDATIONS_BASEDIR, 'lookup_plugins')

COMMUNITY_VALIDATIONS_SUBDIR = [COMMUNITY_ROLES_DIR,
                                COMMUNITY_PLAYBOOKS_DIR,
                                COMMUNITY_LIBRARY_DIR,
                                COMMUNITY_LOOKUP_DIR]

COMMUNITY_PLAYBOOK_TEMPLATE = \
"""---
# This playbook has been generated by the `validation init` CLI.
#
# As shown here in this template, the validation playbook requires three
# top-level directive:
#   ``hosts``, ``vars -> metadata`` and ``roles``.
#
# ``hosts``: specifies which nodes to run the validation on. The options can
#            be ``all`` (run on all nodes), or you could use the hosts defined
#            in the inventory.
# ``vars``: this section serves for storing variables that are going to be
#           available to the Ansible playbook. The validations API uses the
#           ``metadata`` section to read each validation's name and description
#           These values are then reported by the API.
#
# The validations can be grouped together by specyfying a ``groups`` metadata.
# Groups function similar to tags and a validation can thus be part of many
# groups. To get a full list of the groups available and their description,
# please run the following command on your Ansible Controller host:
#
#    $ validation show group
#
# The validations can also be categorized by technical domain and acan belong to
# one or multiple ``categories``. For example, if your validation checks some
# networking related configuration, you may want to put ``networking`` as a
# category.  Note that this section is open and you are free to categorize your
# validations as you like.
#
# The ``products`` section refers to the product on which you would like to run
# the validation. It's another way to categorized your community validations.
# Note that, by default, ``community`` is set in the ``products`` section to
# help you list your validations by filtering by products:
#
#    $ validation list --product community
#
- hosts: hostname
  gather_facts: false
  vars:
    metadata:
      name: Brief and general description of the validation
      description: |
        The complete description of this validation should be here
# GROUPS:
# Run ``validation show group`` to get the list of groups
# :type group: `list`
# If you don't want to add groups for your validation, just
# set an empty list to the groups key
      groups: []
# CATEGORIES:
# :type group: `list`
# If you don't want to categorize your validation, just
# set an empty list to the categories key
      categories: []
      products:
        - community
  roles:
    - {}
"""
