# encoding: utf-8
# THIS FILE IS AUTOGENERATED!
from __future__ import unicode_literals
from setuptools import setup
setup(
    author='Rohit Kumar, Kyle Lahnakoski',
    author_email='rohitkumar.a255@gmail.com, kyle@lahnakoski.com',
    classifiers=["Development Status :: 4 - Beta","Topic :: Software Development :: Libraries","Topic :: Software Development :: Libraries :: Python Modules","License :: OSI Approved :: Mozilla Public License 2.0 (MPL 2.0)","Programming Language :: Python :: 2.7","Programming Language :: Python :: 3.6","Programming Language :: Python :: 3.7","Programming Language :: Python :: 3.8"],
    description='JSON query expressions using SQLite',
    include_package_data=True,
    install_requires=["hjson","requests"],
    license='MPL 2.0',
    long_description='# jx-sqlite \n\nJSON query expressions using SQLite\n\nhttps://travis-ci.org/klahnakoski/jx-sqlite.svg?branch=master\n\n|Branch      |Status   | \n|------------|---------|\n|master      | [![Build Status](https://travis-ci.org/klahnakoski/jx-sqlite.svg?branch=master)](https://travis-ci.org/klahnakoski/jx-sqlite) |\n|dev         | [![Build Status](https://travis-ci.org/klahnakoski/jx-sqlite.svg?branch=dev)](https://travis-ci.org/klahnakoski/jx-sqlite)    | \n\n## Summary\n\nThis library will manage your database schema to store JSON documents. You get all the speed of a well-formed database schema without the schema migration headaches. \n\nhttps://www.youtube.com/watch?v=0_YLzb7BegI&list=PLSE8ODhjZXja7K1hjZ01UTVDnGQdx5v5U&index=26&t=260s\n\n## Status\n\nSignificant updates to the supporting libraries has broken this ode.  It still works works for the simple cases that require it\n\n**Jan 2020** - 96/283 test failing  \n\n\n## Installation\n\n    pip install jx-sqlite\n\n## Code Example\n\nOpen a database \n\n```python\ncontainer = Container()\n```\n\nDeclare a table\n\n```python\ntable = container.get_or_create_facts("my_table")\n```\n\nPour JSON documents into it\n\n```python\ntable.add({"os":"linux", "value":42})\n```\n\nQuery the table\n\n```python\ntable.query({\n    "select": "os", \n    "where": {"gt": {"value": 0}}\n})\n```\n\n## More\n\nAn attempt to store JSON documents in SQLite so that they are accessible via SQL. The hope is this will serve a basis for a general document-relational map (DRM), and leverage the database\'s query optimizer.\njx-sqlite  is also responsible for making the schema, and changing it dynamically as new JSON schema are encountered and to ensure that the old queries against the new schema have the same meaning.\n\nThe most interesting, and most important feature is that we query nested object arrays as if they were just another table.  This is important for two reasons:\n\n1. Inner objects `{"a": {"b": 0}}` are a shortcut for nested arrays `{"a": [{"b": 0}]}`, plus\n2. Schemas can be expanded from one-to-one  to one-to-many `{"a": [{"b": 0}, {"b": 1}]}`.\n\n\n## Motivation\n\nJSON is a nice format to store data, and it has become quite prevalent. Unfortunately, databases do not handle it well, often a human is required to declare a schema that can hold the JSON before it can be queried. If we are not overwhelmed by the diversity of JSON now, we soon will be. There will be more JSON, of more different shapes, as the number of connected devices( and the information they generate) continues to increase.\n\n## Contributing\n\nContributions are always welcome! The best thing to do is find a failing test, and try to fix it.\n\nThese instructions will get you a copy of the project up and running on your local machine for development and testing purposes.\n\n    $ git clone https://github.com/mozilla/jx-sqlite\n    $ cd jx-sqlite\n\n### Running tests\n\nThere are over 200 tests used to confirm the expected behaviour: They test a variety of JSON forms, and the queries that can be performed on them. Most tests are further split into three different output formats ( list, table and cube).\n\n    export PYTHONPATH=.\n    python -m unittest discover -v -s tests\n\n### Technical Docs\n\n* [Json Query Expression](https://github.com/klahnakoski/ActiveData/blob/dev/docs/jx.md)\n* [Nomenclature](https://github.com/mozilla/jx-sqlite/blob/master/docs/Nomenclature.md)\n* [Snowflake](https://github.com/mozilla/jx-sqlite/blob/master/docs/Perspective.md)\n* [JSON in Database](https://github.com/mozilla/jx-sqlite/blob/master/docs/JSON%20in%20Database.md)\n* [The Future](https://github.com/mozilla/jx-sqlite/blob/master/docs/The%20Future.md)\n\n## License\n\nThis project is licensed under Mozilla Public License, v. 2.0. If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.\n\n\n## History\n\n*Sep 2018* - Upgrade libs, start refactoring to work with other libs\n\n*Dec 2017* - A number of tests were added, but they do not pass.\n\n*Sep 2017* - GSoC work completed, all but a few tests pass.\n \n\n## GSOC\n\nWork done upto the deadline of GSoC\'17:\n\n* [Pull Requests](https://github.com/mozilla/jx-sqlite/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Arohit-rk)\n* [Commits](https://github.com/mozilla/jx-sqlite/commits?author=rohit-rk)\n\n\n## More Documentation\n\n* [The Future](https://github.com/mozilla/jx-sqlite/blob/master/docs/The%20Future.md)\n',
    long_description_content_type='text/markdown',
    name='jx-sqlite',
    package_dir={"jx_base":"vendor/jx_base","jx_python":"vendor/jx_python","mo_collections":"vendor/mo_collections","mo_dots":"vendor/mo_dots","mo_files":"vendor/mo_files","mo_future":"vendor/mo_future","mo_imports":"vendor/mo_imports","mo_json":"vendor/mo_json","mo_json_config":"vendor/mo_json_config","mo_kwargs":"vendor/mo_kwargs","mo_logs":"vendor/mo_logs","mo_math":"vendor/mo_math","mo_sql":"vendor/mo_sql","mo_testing":"vendor/mo_testing","mo_threads":"vendor/mo_threads","mo_times":"vendor/mo_times","pyLibrary":"vendor/pyLibrary"},
    packages=["jx_sqlite","jx_sqlite.expressions","jx_base","jx_base.expressions","jx_python","jx_python.expressions","jx_python.containers","jx_python.cubes","jx_python.lists","jx_python.namespace","mo_collections","mo_dots","mo_files","mo_future","mo_imports","mo_json","mo_json_config","mo_kwargs","mo_logs","mo_math","mo_sql","mo_testing","mo_threads","mo_times","mo_times.vendor.dateutil.zoneinfo","mo_times.vendor.dateutil","mo_times.vendor","mo_times","pyLibrary","pyLibrary.env","mo_math.vendor","mo_math.vendor.aespython","mo_math.vendor.strangman"],
    url='https://github.com/klahnakoski/jx-sqlite',
    version='4.38.21125'
)