"use strict";
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'isAuthorizer correctly detects an instance of type Authorizer'(test) {
        class MyAuthorizer extends lib_1.Authorizer {
            constructor() {
                super(...arguments);
                this.authorizerId = 'test-authorizer-id';
            }
            _attachToApi(_) {
                // do nothing
            }
        }
        const stack = new core_1.Stack();
        const authorizer = new MyAuthorizer(stack, 'authorizer');
        test.ok(lib_1.Authorizer.isAuthorizer(authorizer), 'type Authorizer expected but is not');
        test.ok(!lib_1.Authorizer.isAuthorizer(stack), 'type Authorizer found, when not expected');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5hdXRob3JpemVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGVzdC5hdXRob3JpemVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSx3Q0FBc0M7QUFFdEMsZ0NBQThDO0FBRTlDLGlCQUFTO0lBQ1AsK0RBQStELENBQUMsSUFBVTtRQUN4RSxNQUFNLFlBQWEsU0FBUSxnQkFBVTtZQUFyQzs7Z0JBQ2tCLGlCQUFZLEdBQUcsb0JBQW9CLENBQUM7WUFJdEQsQ0FBQztZQUhRLFlBQVksQ0FBQyxDQUFXO2dCQUM3QixhQUFhO1lBQ2YsQ0FBQztTQUNGO1FBQ0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLEVBQUUsQ0FBQztRQUMxQixNQUFNLFVBQVUsR0FBRyxJQUFJLFlBQVksQ0FBQyxLQUFLLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFFekQsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBVSxDQUFDLFlBQVksQ0FBQyxVQUFVLENBQUMsRUFBRSxxQ0FBcUMsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQyxnQkFBVSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsRUFBRSwwQ0FBMEMsQ0FBQyxDQUFDO1FBRXJGLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgeyBBdXRob3JpemVyLCBJUmVzdEFwaSB9IGZyb20gJy4uL2xpYic7XG5cbmV4cG9ydCA9IHtcbiAgJ2lzQXV0aG9yaXplciBjb3JyZWN0bHkgZGV0ZWN0cyBhbiBpbnN0YW5jZSBvZiB0eXBlIEF1dGhvcml6ZXInKHRlc3Q6IFRlc3QpIHtcbiAgICBjbGFzcyBNeUF1dGhvcml6ZXIgZXh0ZW5kcyBBdXRob3JpemVyIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSBhdXRob3JpemVySWQgPSAndGVzdC1hdXRob3JpemVyLWlkJztcbiAgICAgIHB1YmxpYyBfYXR0YWNoVG9BcGkoXzogSVJlc3RBcGkpOiB2b2lkIHtcbiAgICAgICAgLy8gZG8gbm90aGluZ1xuICAgICAgfVxuICAgIH1cbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuICAgIGNvbnN0IGF1dGhvcml6ZXIgPSBuZXcgTXlBdXRob3JpemVyKHN0YWNrLCAnYXV0aG9yaXplcicpO1xuXG4gICAgdGVzdC5vayhBdXRob3JpemVyLmlzQXV0aG9yaXplcihhdXRob3JpemVyKSwgJ3R5cGUgQXV0aG9yaXplciBleHBlY3RlZCBidXQgaXMgbm90Jyk7XG4gICAgdGVzdC5vayghQXV0aG9yaXplci5pc0F1dGhvcml6ZXIoc3RhY2spLCAndHlwZSBBdXRob3JpemVyIGZvdW5kLCB3aGVuIG5vdCBleHBlY3RlZCcpO1xuXG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG59OyJdfQ==