// Copyright (c) Mito
import React, { useEffect } from 'react';
import { ModalEnum } from './modals';
import DefaultModal from '../DefaultModal';
import TextButton from '../elements/TextButton';
/*
  A modal that confirms with the user that they want to clear
  the entire analysis export for simple import steps
*/
const ClearAnalysisModal = (props) => {
    useEffect(() => {
        // Log that we opened this
        void props.mitoAPI.log('click_open_clear_analysis');
    }, []);
    const clickClear = async () => {
        // Actually send the reset message
        void props.mitoAPI.updateClear();
        // Close the modal
        props.setUIState((prevUIState) => {
            return Object.assign(Object.assign({}, prevUIState), { currOpenModal: { type: ModalEnum.None } });
        });
    };
    return (React.createElement(DefaultModal, { header: `Clear your current analysis?`, modalType: ModalEnum.ClearAnalysis, viewComponent: React.createElement(React.Fragment, null,
            React.createElement("p", { className: 'body-text-1' }, "This will undo all transformations you have made to imported dataframes.")), buttons: React.createElement(React.Fragment, null,
            React.createElement(TextButton, { variant: 'light', width: 'small', onClick: () => {
                    props.setUIState((prevUIState) => {
                        return Object.assign(Object.assign({}, prevUIState), { currOpenModal: { type: ModalEnum.None } });
                    });
                } }, "Close"),
            React.createElement(TextButton, { variant: 'dark', width: 'small', onClick: clickClear }, "Clear")) }));
};
export default ClearAnalysisModal;
//# sourceMappingURL=ClearAnalysisModal.js.map