// Copyright (c) Mito
import React from 'react';
import PivotTableColumnHeaderCard from './PivotTableColumnHeaderCard';
import PivotInvalidSelectedColumnsError from './PivotInvalidSelectedColumnsError';
import DropdownButton from '../../elements/DropdownButton';
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
import DropdownItem from '../../elements/DropdownItem';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
/*
  A custom component used in the pivot table which lets the
  user select column headers to add to the row or column keys
*/
const PivotTableKeySelection = (props) => {
    const pivotTableColumnIDsCards = props.selectedColumnIDs.map((columnID, keyIndex) => {
        return (React.createElement(PivotTableColumnHeaderCard, { key: columnID + keyIndex, columnIDsMap: props.columnIDsMap, columnID: columnID, keyIndex: keyIndex, removeKey: props.removeKey, editKey: props.editKey }));
    });
    return (React.createElement("div", null,
        React.createElement(Row, { justify: 'space-between', align: 'center' },
            React.createElement(Col, null,
                React.createElement("p", { className: 'text-header-3' }, props.sectionTitle)),
            React.createElement(Col, null,
                React.createElement(DropdownButton, { text: '+ Add', width: 'small', searchable: true }, Object.entries(props.columnIDsMap).map(([columnID, columnHeader]) => {
                    return (React.createElement(DropdownItem, { key: columnID, title: getDisplayColumnHeader(columnHeader), onClick: () => {
                            props.addKey(columnID);
                        } }));
                })))),
        React.createElement(PivotInvalidSelectedColumnsError, { columnIDsMap: props.columnIDsMap, selectedColumnIDs: props.selectedColumnIDs, pivotSection: props.rowOrColumn, mitoAPI: props.mitoAPI }),
        pivotTableColumnIDsCards));
};
export default PivotTableKeySelection;
//# sourceMappingURL=PivotTableKeySelection.js.map