// Copyright (c) Mito
import React from 'react';
import UndoIcon from '../icons/UndoIcon';
import ImportIcon from '../icons/ImportIcon';
import ExportIcon from '../icons/ExportIcon';
import MergeIcon from '../icons/MergeIcon';
import PivotIcon from '../icons/PivotIcon';
import DeleteColumnIcon from '../icons/DeleteColumnIcon';
import AddColumnIcon from '../icons/AddColumnIcon';
import DocumentationIcon from '../icons/DocumentationIcon';
import { CloseFullscreenIcon, OpenFullscreenIcon } from '../icons/FullscreenIcons';
import StepsIcon from '../icons/StepsIcon';
import CatchUpIcon from '../icons/CatchUpIcon';
import GraphIcon from '../icons/GraphIcon';
import RedoIcon from '../icons/RedoIcon';
import ClearIcon from '../icons/ClearIcon';
import DropDuplicatesIcon from '../icons/DropDuplicatesIcon';
import FormatIcon from '../icons/FormatIcon';
/*
    Each button in the toolbar is one of the ToolbarButtonType.
    We use the ToolbarButtonType to get the correct icons for each button.

    In the future, we will also use this type to do things like having one function
    that can be used to specify any toolbar item to have attention drawn to. ie:
    through the tour.
*/
export var ToolbarButtonType;
(function (ToolbarButtonType) {
    ToolbarButtonType["UNDO"] = "UNDO";
    ToolbarButtonType["REDO"] = "REDO";
    ToolbarButtonType["CLEAR"] = "CLEAR";
    ToolbarButtonType["IMPORT"] = "IMPORT";
    ToolbarButtonType["EXPORT"] = "EXPORT";
    ToolbarButtonType["ADD_COL"] = "ADD COL";
    ToolbarButtonType["DEL_COL"] = "DEL COL";
    ToolbarButtonType["PIVOT"] = "PIVOT";
    ToolbarButtonType["MERGE"] = "MERGE";
    ToolbarButtonType["DROP_DUPLICATES"] = "DROP DUPLICATES";
    ToolbarButtonType["GRAPH"] = "GRAPH";
    ToolbarButtonType["FORMAT"] = "FORMAT";
    ToolbarButtonType["CATCH_UP"] = "CATCH UP";
    ToolbarButtonType["STEPS"] = "STEPS";
    ToolbarButtonType["DOCS"] = "DOCS";
    ToolbarButtonType["OPEN_FULLSCREEN"] = "OPEN FULLSCREEN";
    ToolbarButtonType["CLOSE_FULLSCREEN"] = "CLOSE FULLSCREEN";
})(ToolbarButtonType || (ToolbarButtonType = {}));
/*
    Helper function for getting the light and dark version of each
    toolbar icon.
*/
export const getToolbarItemIcon = (toolbarButtonType) => {
    switch (toolbarButtonType) {
        case ToolbarButtonType.UNDO: return {
            darkIcon: React.createElement(UndoIcon, null),
            lightIcon: React.createElement(UndoIcon, { variant: 'light' })
        };
        case ToolbarButtonType.REDO: return {
            darkIcon: React.createElement(RedoIcon, null),
            lightIcon: React.createElement(RedoIcon, { variant: 'light' })
        };
        case ToolbarButtonType.CLEAR: return {
            darkIcon: React.createElement(ClearIcon, null),
            lightIcon: React.createElement(ClearIcon, { variant: 'light' })
        };
        case ToolbarButtonType.IMPORT: return {
            darkIcon: React.createElement(ImportIcon, null),
            lightIcon: React.createElement(ImportIcon, { variant: 'light' })
        };
        case ToolbarButtonType.EXPORT: return {
            darkIcon: React.createElement(ExportIcon, null),
            lightIcon: React.createElement(ExportIcon, { variant: 'light' })
        };
        case ToolbarButtonType.ADD_COL: return {
            darkIcon: React.createElement(AddColumnIcon, null),
            lightIcon: React.createElement(AddColumnIcon, { variant: 'light' })
        };
        case ToolbarButtonType.DEL_COL: return {
            darkIcon: React.createElement(DeleteColumnIcon, null),
            lightIcon: React.createElement(DeleteColumnIcon, { variant: 'light' })
        };
        case ToolbarButtonType.PIVOT: return {
            darkIcon: React.createElement(PivotIcon, null),
            lightIcon: React.createElement(PivotIcon, { variant: 'light' })
        };
        case ToolbarButtonType.MERGE: return {
            darkIcon: React.createElement(MergeIcon, null),
            lightIcon: React.createElement(MergeIcon, { variant: 'light' })
        };
        case ToolbarButtonType.DROP_DUPLICATES: return {
            darkIcon: React.createElement(DropDuplicatesIcon, null),
            lightIcon: React.createElement(DropDuplicatesIcon, { variant: 'light' })
        };
        case ToolbarButtonType.GRAPH: return {
            darkIcon: React.createElement(GraphIcon, null),
            lightIcon: React.createElement(GraphIcon, { variant: 'light' })
        };
        case ToolbarButtonType.FORMAT: return {
            darkIcon: React.createElement(FormatIcon, null),
            lightIcon: React.createElement(FormatIcon, { variant: 'light' })
        };
        case ToolbarButtonType.CATCH_UP: return {
            darkIcon: React.createElement(CatchUpIcon, null),
            lightIcon: React.createElement(CatchUpIcon, { variant: 'light' })
        };
        case ToolbarButtonType.STEPS: return {
            darkIcon: React.createElement(StepsIcon, null),
            lightIcon: React.createElement(StepsIcon, { variant: 'light' })
        };
        case ToolbarButtonType.DOCS: return {
            darkIcon: React.createElement(DocumentationIcon, null),
            lightIcon: React.createElement(DocumentationIcon, { variant: 'light' })
        };
        case ToolbarButtonType.OPEN_FULLSCREEN: return {
            darkIcon: React.createElement(OpenFullscreenIcon, null),
            lightIcon: React.createElement(OpenFullscreenIcon, { variant: 'light' })
        };
        case ToolbarButtonType.CLOSE_FULLSCREEN: return {
            darkIcon: React.createElement(CloseFullscreenIcon, null),
            lightIcon: React.createElement(CloseFullscreenIcon, { variant: 'light' })
        };
    }
};
//# sourceMappingURL=utils.js.map