import React from 'react';
import { DOCUMENTATION_LINK_TUTORIAL } from '../../data/documentationLinks';
/*
    The name used to identify the tour in the tours mapping.
    The string declared here is written to the user.json file to register
    that the tour has already been taken.

    Note: changing the strings will cause the user to receive the tour again!
*/
export var TourName;
(function (TourName) {
    TourName["INTRO"] = "Intro";
    TourName["PIVOT"] = "Pivot";
    TourName["TUTORIAL"] = "Tutorial";
    TourName["COLUMN_FORMULAS"] = "Column_Formulas";
    TourName["EXPLORE_DATA"] = "Explore_Datasets";
})(TourName || (TourName = {}));
// Location to display the TourStep popup
export var TourPopupLocation;
(function (TourPopupLocation) {
    TourPopupLocation["BOTTOM_LEFT"] = "bottom_left";
    TourPopupLocation["BOTTOM_RIGHT"] = "bottom_right";
    TourPopupLocation["TOP_LEFT"] = "top_left";
    TourPopupLocation["TOP_RIGHT"] = "top_right";
})(TourPopupLocation || (TourPopupLocation = {}));
const introTourSteps = [
    {
        tourName: TourName.INTRO,
        stepNumber: 1,
        stepHeader: 'Seeing your data',
        stepHeaderBackgroundColor: '#BCDFBC',
        stepText: React.createElement("div", null, " Your data is visible in the sheet. Each dataframe is represented by a different tab. "),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: false,
        hideXIcon: true
    },
    {
        tourName: TourName.INTRO,
        stepNumber: 2,
        stepHeader: 'Search for functionality',
        stepHeaderBackgroundColor: '#DDA1A1',
        stepText: React.createElement("div", null, " If you're not sure how to do something in Mito, search for it! Try typing something in the search bar above. "),
        location: TourPopupLocation.TOP_RIGHT,
        advanceButtonText: "Continue",
        displayBackButton: true,
        hideXIcon: true
    },
    {
        tourName: TourName.INTRO,
        stepNumber: 3,
        stepHeader: 'Use the generated code',
        stepHeaderBackgroundColor: '#79C2F8',
        stepText: React.createElement("div", null, "Each time you make an edit, Mito generates equivalent Python code in the cell below. Running this generated code edits the dataframes in your notebook directly."),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
];
const pivotTourSteps = [
    {
        tourName: TourName.PIVOT,
        stepNumber: 1,
        stepHeader: 'Creating a pivot table',
        stepHeaderBackgroundColor: '#BCDFBC',
        stepText: React.createElement("div", null,
            " ",
            React.createElement("b", null, " Click on the Pivot button"),
            " to get started. Mito\u2019s pivot tables make it easy to slice and dice your data into different categories. "),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true,
    },
    {
        tourName: TourName.PIVOT,
        stepNumber: 2,
        stepHeader: 'Configure your pivot table',
        stepHeaderBackgroundColor: '#DDA1A1',
        stepText: React.createElement("div", null,
            " In the open sidebar, ",
            React.createElement("b", null, "select a row and value "),
            " to create your pivot table."),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
    {
        tourName: TourName.PIVOT,
        stepNumber: 3,
        stepHeader: 'That was easy!',
        stepHeaderBackgroundColor: '#79C2F8',
        stepText: React.createElement("div", null,
            React.createElement("b", null, "Checkout the pivot table code below"),
            ". Each time you create a pivot table, a new dataframe is created in both the Mito sheet and the generated code. We just saved our first few trips to stack overflow :) "),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
];
const ColumnFormulasTourSteps = [
    {
        tourName: TourName.COLUMN_FORMULAS,
        stepNumber: 1,
        stepHeader: 'Writing Excel formulas',
        stepHeaderBackgroundColor: '#BCDFBC',
        stepText: React.createElement("div", null,
            " Mito supports the most popular Excel functions, making it easy to transform your data with the formulas you\u2019re most comfortable with. ",
            React.createElement("b", null, "Click on the Add Col button"),
            " to create a new column. "),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true,
    },
    {
        tourName: TourName.COLUMN_FORMULAS,
        stepNumber: 2,
        stepHeader: 'Open the cell editor',
        stepHeaderBackgroundColor: '#DDA1A1',
        stepText: React.createElement("div", null,
            " ",
            React.createElement("b", null, "Click on any cell in your new column"),
            " -- it's to the right of your selected column. ",
            React.createElement("b", null, "Press Enter"),
            " to open the cell editor. "),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
    {
        tourName: TourName.COLUMN_FORMULAS,
        stepNumber: 3,
        stepHeader: 'Write your first formula',
        stepHeaderBackgroundColor: '#79C2F8',
        // eslint-disable-next-line react/display-name
        stepTextFunction: (columnHeader) => {
            return (React.createElement("div", null,
                React.createElement("b", null,
                    "Write the formula =LEN(",
                    columnHeader,
                    ") "),
                " in the cell editor and ",
                React.createElement("b", null, " press Enter"),
                ". The LEN formula returns the length of each cell in column ",
                columnHeader,
                "."));
        },
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
    {
        tourName: TourName.COLUMN_FORMULAS,
        stepNumber: 4,
        stepHeader: 'Give your column a name',
        stepHeaderBackgroundColor: '#79C2F8',
        // eslint-disable-next-line react/display-name
        stepTextFunction: (columnHeader) => {
            return (React.createElement("div", null,
                React.createElement("b", null, "Click on the column's header "),
                " to give your column a more meaningful name. At the top of the sidebar that appears, ",
                React.createElement("b", null,
                    "name the column Len_of_",
                    columnHeader,
                    " ")));
        },
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
    {
        tourName: TourName.COLUMN_FORMULAS,
        stepNumber: 5,
        stepHeader: "See all of Mito's formulas",
        stepHeaderBackgroundColor: '#79C2F8',
        stepText: React.createElement("div", null,
            "Congrats on writing your first formula! To see a full list of Mito\u2019s functions, ",
            React.createElement("b", null, "click on the Docs"),
            " button in the top right corner of Mito."),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
];
const ExploreDataTourSteps = [
    {
        tourName: TourName.EXPLORE_DATA,
        stepNumber: 1,
        stepHeader: 'Exploring data with Mito',
        stepHeaderBackgroundColor: '#BCDFBC',
        stepText: React.createElement("div", null,
            " Mito makes it easy to build intuition for your data by automatically generating summary information about each column. To get started, ",
            React.createElement("b", null, "click on the filter button in the column header"),
            " of one of your columns."),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true,
    },
    {
        tourName: TourName.EXPLORE_DATA,
        stepNumber: 2,
        stepHeader: 'View summary stats',
        stepHeaderBackgroundColor: '#CAD1FF',
        stepText: React.createElement("div", null,
            " ",
            React.createElement("b", null, "Click on the Summary Stats tab "),
            " at the bottom of the sidebar. The chart at the top shows you the distribution of your column, and there\u2019s more specific summary information down below. Check it out!"),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
    {
        tourName: TourName.EXPLORE_DATA,
        stepNumber: 3,
        stepHeader: 'Add a filter',
        stepHeaderBackgroundColor: '#FFDAAE',
        stepText: React.createElement("div", null,
            React.createElement("b", null, "Switch over to the Filter/Sort Tab "),
            " to clean up your data now that you've built up some intuition.  "),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
    {
        tourName: TourName.EXPLORE_DATA,
        stepNumber: 4,
        stepHeader: "Create a filter",
        stepHeaderBackgroundColor: '#79C2F8',
        stepText: React.createElement("div", null,
            React.createElement("b", null, "Click on the Add Filter button "),
            ", and then set the filter ",
            React.createElement("b", null, "condition and value"),
            ". "),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
    {
        tourName: TourName.EXPLORE_DATA,
        stepNumber: 5,
        stepHeader: "Enjoy your cleaned data",
        stepHeaderBackgroundColor: '#FFCBDE',
        stepText: React.createElement("div", null, "Nice work! In just a few clicks, we\u2019ve built some intuition for our data and removed the values we're not interested in. "),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Continue",
        displayBackButton: true
    },
];
const tutorialTourSteps = [
    {
        tourName: TourName.TUTORIAL,
        stepNumber: 1,
        stepHeader: 'Before you go!',
        stepHeaderBackgroundColor: '#FFDAAE',
        stepText: React.createElement("div", null,
            "If you want more information on how to clean and analyze your data by writing spreadsheet formulas, visualizing your data, and adding filters, checkout our more detailed tutorial ",
            React.createElement("a", { href: DOCUMENTATION_LINK_TUTORIAL, target: "_blank", rel: "noreferrer", style: { color: '#0081DE' } }, "here"),
            "."),
        location: TourPopupLocation.BOTTOM_LEFT,
        advanceButtonText: "Close",
        displayBackButton: true
    }
];
export const tours = {
    'Intro': introTourSteps,
    'Pivot': pivotTourSteps,
    'Tutorial': tutorialTourSteps,
    'Column_Formulas': ColumnFormulasTourSteps,
    'Explore_Datasets': ExploreDataTourSteps
};
//# sourceMappingURL=Tours.js.map