import { IVpc, InstanceType } from '@aws-cdk/aws-ec2';
import * as lambda from '@aws-cdk/aws-lambda';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 *
 */
export interface DatabaseConfig {
    /**
     * The DB writer endpoint.
     */
    readonly writerEndpoint: string;
    /**
     * The DB reader endpoint.
     */
    readonly readerEndpoint?: string;
    /**
     * The DB master username.
     */
    readonly masterUserName?: string;
    /**
     * The DB master password secret.
     */
    readonly masterUserPasswordSecret?: secretsmanager.ISecret;
}
/**
 * Construct properties for `ServerlessApi`.
 */
export interface ServerlessApiProps {
    /**
     * custom lambda function for the API.
     *
     * @default - A Lambda function with Lavavel and Bref support will be created
     */
    readonly handler?: lambda.IFunction;
    /**
     * custom lambda code asset path.
     *
     * @default - DEFAULT_LAMBDA_ASSET_PATH
     */
    readonly lambdaCodePath?: string;
    /**
     * AWS Lambda layer version from the Bref runtime.
     *
     * e.g. arn:aws:lambda:us-west-1:209497400698:layer:php-74-fpm:12
     * check the latest runtime verion arn at https://bref.sh/docs/runtimes/
     */
    readonly brefLayerVersion: string;
    /**
     * The VPC for this stack.
     */
    readonly vpc?: IVpc;
    /**
     * Database configurations.
     */
    readonly databaseConfig?: DatabaseConfig;
    /**
     * RDS Proxy for the Lambda function.
     *
     * @default - no db proxy
     */
    readonly rdsProxy?: rds.IDatabaseProxy;
}
/**
 * Use `ServerlessApi` to create the serverless API resource.
 */
export declare class ServerlessApi extends cdk.Construct {
    /**
     *
     */
    readonly handler: lambda.IFunction;
    /**
     *
     */
    readonly vpc?: IVpc;
    /**
     *
     */
    constructor(scope: cdk.Construct, id: string, props: ServerlessApiProps);
}
/**
 * Construct properties for `ServerlessLaravel`.
 */
export interface ServerlessLaravelProps extends ServerlessApiProps {
    /**
     * path to your local laravel directory with bref.
     */
    readonly laravelPath: string;
}
/**
 * Use `ServerlessLaravel` to create the serverless Laravel resource.
 */
export declare class ServerlessLaravel extends cdk.Construct {
    /**
     *
     */
    constructor(scope: cdk.Construct, id: string, props: ServerlessLaravelProps);
}
/**
 *
 */
export interface DatabaseProps {
    /**
     * database cluster engine.
     *
     * @default AURORA_MYSQL
     */
    readonly engine?: rds.IClusterEngine;
    /**
     * master username.
     *
     * @default admin
     */
    readonly masterUserName?: string;
    /**
     * The VPC for the DatabaseCluster.
     */
    readonly vpc: IVpc;
    /**
     * instance type of the cluster.
     *
     * @default - t3.medium (or, more precisely, db.t3.medium)
     */
    readonly instanceType?: InstanceType;
    /**
     * enable the Amazon RDS proxy.
     *
     * @default true
     */
    readonly rdsProxy?: boolean;
    /**
     * RDS Proxy Options.
     */
    readonly rdsProxyOptions?: rds.DatabaseProxyOptions;
    /**
     * How many replicas/instances to create.
     *
     * Has to be at least 1.
     *
     * @default 1
     */
    readonly instanceCapacity?: number;
}
/**
 *
 */
export declare class DatabaseCluster extends cdk.Construct {
    /**
     *
     */
    readonly rdsProxy?: rds.DatabaseProxy;
    /**
     *
     */
    readonly masterUser: string;
    /**
     *
     */
    readonly masterPassword: secretsmanager.ISecret;
    /**
     *
     */
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
}
