"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sns = exports.EmailEncoding = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The type of email encoding to use for a SNS action.
 */
var EmailEncoding;
(function (EmailEncoding) {
    /**
     * Base 64
     */
    EmailEncoding["BASE64"] = "Base64";
    /**
     * UTF-8
     */
    EmailEncoding["UTF8"] = "UTF-8";
})(EmailEncoding = exports.EmailEncoding || (exports.EmailEncoding = {}));
/**
 * Publishes the email content within a notification to Amazon SNS.
 */
class Sns {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_SnsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Sns);
            }
            throw error;
        }
    }
    bind(_rule) {
        return {
            snsAction: {
                encoding: this.props.encoding,
                topicArn: this.props.topic.topicArn,
            },
        };
    }
}
exports.Sns = Sns;
_a = JSII_RTTI_SYMBOL_1;
Sns[_a] = { fqn: "@aws-cdk/aws-ses-actions.Sns", version: "1.162.0" };
//# sourceMappingURL=data:application/json;base64,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