# Generated by Django 3.0.4 on 2020-04-25 22:07

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import kmuhelper.modules.main.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Ansprechpartner',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Name')),
                ('telefon', models.CharField(max_length=50, verbose_name='Telefon')),
                ('email', models.EmailField(max_length=254, verbose_name='E-Mail')),
            ],
            options={
                'verbose_name': 'Ansprechpartner',
                'verbose_name_plural': 'Ansprechpartner',
            },
        ),
        migrations.CreateModel(
            name='Bestellung',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('woocommerceid', models.IntegerField(default=0, verbose_name='WooCommerce ID')),
                ('datum', models.DateTimeField(auto_now_add=True, verbose_name='Erfasst am')),
                ('status', models.CharField(choices=[('pending', 'Zahlung ausstehend'), ('processing', 'In Bearbeitung'), ('on-hold', 'In Wartestellung'), ('completed', 'Abgeschlossen'), ('cancelled', 'Storniert/Abgebrochen'), ('refunded', 'Rückerstattet'), ('failed', 'Fehlgeschlagen'), ('trash', 'Gelöscht')], default='pending', max_length=11, verbose_name='Status')),
                ('versendet', models.BooleanField(default=False, help_text='Sobald eine Bestellung als versendet markiert wurde, kann sie nicht mehr bearbeitet werden! (Ausgenommen Status/Bezahlt) Ausserdem werden die Produkte aus dem Lagerbestand entfernt.', verbose_name='Versendet')),
                ('trackingnummer', models.CharField(blank=True, default='', help_text='Bitte gib hier einen Trackinglink der Schweizer Post ein. (optional)', max_length=25, validators=[django.core.validators.RegexValidator('^99\\.[0-9]{2}\\.[0-9]{6}\\.[0-9]{8}$', 'Bite benutze folgendes Format: 99.xx.xxxxxx.xxxxxxxx')], verbose_name='Trackingnummer')),
                ('ausgelagert', models.BooleanField(default=False, verbose_name='Ausgelagert')),
                ('zahlungsmethode', models.CharField(choices=[('bacs', 'Überweisung'), ('cheque', 'Scheck'), ('cod', 'Nachnahme/Rechnung'), ('paypal', 'PayPal')], default='cod', max_length=7, verbose_name='Zahlungsmethode')),
                ('bezahlt', models.BooleanField(default=False, help_text='Sobald eine Bestellung als bezahlt markiert wurde, kann sie nicht mehr bearbeitet werden! (Ausgenommen Status/Versendet/Trackingnummer)', verbose_name='Bezahlt')),
                ('kundennotiz', models.TextField(blank=True, default='', help_text='Vom Kunden erfasste Notiz.', verbose_name='Kundennotiz')),
                ('rechnungsnotiz', models.TextField(blank=True, default='', help_text='Wird auf der Rechnung gedruckt.', verbose_name='Rechnungsnotiz')),
                ('notiz', models.TextField(blank=True, default='', help_text='Nur für eigene Zwecke.', verbose_name='Notiz')),
                ('order_key', models.CharField(blank=True, default='', max_length=50, verbose_name='Bestellungs-Schlüssel')),
                ('rechnungsadresse_vorname', models.CharField(blank=True, default='', max_length=50, verbose_name='Vorname')),
                ('rechnungsadresse_nachname', models.CharField(blank=True, default='', max_length=50, verbose_name='Nachname')),
                ('rechnungsadresse_firma', models.CharField(blank=True, default='', max_length=50, verbose_name='Firma')),
                ('rechnungsadresse_adresszeile1', models.CharField(blank=True, default='', help_text='Strasse und Hausnummer oder "Postfach"', max_length=50, verbose_name='Adresszeile 1')),
                ('rechnungsadresse_adresszeile2', models.CharField(blank=True, default='', help_text='Nicht verwenden!', max_length=50, verbose_name='Adresszeile 2')),
                ('rechnungsadresse_ort', models.CharField(blank=True, default='', max_length=50, verbose_name='Ort')),
                ('rechnungsadresse_kanton', models.CharField(blank=True, default='', max_length=50, verbose_name='Kanton')),
                ('rechnungsadresse_plz', models.CharField(blank=True, default='', max_length=50, verbose_name='Postleitzahl')),
                ('rechnungsadresse_land', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('rechnungsadresse_email', models.EmailField(blank=True, max_length=254, verbose_name='E-Mail Adresse')),
                ('rechnungsadresse_telefon', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('lieferadresse_vorname', models.CharField(blank=True, default='', max_length=50, verbose_name='Vorname')),
                ('lieferadresse_nachname', models.CharField(blank=True, default='', max_length=50, verbose_name='Nachname')),
                ('lieferadresse_firma', models.CharField(blank=True, default='', max_length=50, verbose_name='Firma')),
                ('lieferadresse_adresszeile1', models.CharField(blank=True, default='', max_length=50, verbose_name='Adresszeile 1')),
                ('lieferadresse_adresszeile2', models.CharField(blank=True, default='', max_length=50, verbose_name='Adresszeile 2')),
                ('lieferadresse_ort', models.CharField(blank=True, default='', max_length=50, verbose_name='Ort')),
                ('lieferadresse_kanton', models.CharField(blank=True, default='', max_length=50, verbose_name='Kanton')),
                ('lieferadresse_plz', models.CharField(blank=True, default='', max_length=50, verbose_name='Postleitzahl')),
                ('lieferadresse_land', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('ansprechpartner', models.ForeignKey(default=kmuhelper.modules.main.models.default_contact_person, on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.Ansprechpartner', verbose_name='Ansprechpartner')),
            ],
            options={
                'verbose_name': 'Bestellung',
                'verbose_name_plural': 'Bestellungen',
            },
        ),
        migrations.CreateModel(
            name='Einstellung',
            fields=[
                ('id', models.CharField(max_length=20, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20, verbose_name='Name')),
                ('inhalt', models.CharField(blank=True, default='', max_length=250, verbose_name='Inhalt')),
            ],
            options={
                'verbose_name': 'Einstellung',
                'verbose_name_plural': 'Einstellungen',
            },
        ),
        migrations.CreateModel(
            name='Geheime_Einstellung',
            fields=[
                ('id', models.CharField(max_length=20, primary_key=True, serialize=False, verbose_name='ID')),
                ('inhalt', models.CharField(blank=True, default='', max_length=250, verbose_name='Inhalt')),
            ],
            options={
                'verbose_name': 'Geheime Einstellung',
                'verbose_name_plural': 'Geheime Einstellungen',
            },
        ),
        migrations.CreateModel(
            name='Kategorie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('woocommerceid', models.IntegerField(default=0, verbose_name='WooCommerce ID')),
                ('name', models.CharField(default='', max_length=250, verbose_name='Name')),
                ('beschrieb', models.TextField(blank=True, default='', verbose_name='Beschrieb')),
                ('bildlink', models.URLField(blank=True, verbose_name='Bildlink')),
                ('uebergeordnete_kategorie', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.Kategorie', verbose_name='Übergeordnete Kategorie')),
            ],
            options={
                'verbose_name': 'Kategorie',
                'verbose_name_plural': 'Kategorien',
            },
        ),
        migrations.CreateModel(
            name='Kosten',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='Zusätzliche Kosten', max_length=50, verbose_name='Name')),
                ('preis', models.FloatField(default=0.0, verbose_name='Preis')),
                ('versteuerbar', models.BooleanField(default=True, verbose_name='Versteuerbar')),
            ],
            options={
                'verbose_name': 'Kosten',
                'verbose_name_plural': 'Kosten',
            },
        ),
        migrations.CreateModel(
            name='Kunde',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('woocommerceid', models.IntegerField(default=0, verbose_name='WooCommerce ID')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='E-Mail Adresse')),
                ('vorname', models.CharField(blank=True, default='', max_length=50, verbose_name='Vorname')),
                ('nachname', models.CharField(blank=True, default='', max_length=50, verbose_name='Nachname')),
                ('benutzername', models.CharField(blank=True, default='', max_length=50, verbose_name='Benutzername')),
                ('avatar_url', models.URLField(blank=True, editable=False, verbose_name='Avatar URL')),
                ('sprache', models.CharField(choices=[('de', 'Deutsch [DE]'), ('fr', 'Französisch [FR]'), ('it', 'Italienisch [IT]'), ('en', 'Englisch [EN]')], default='de', max_length=2, verbose_name='Sprache')),
                ('rechnungsadresse_vorname', models.CharField(blank=True, default='', max_length=50, verbose_name='Vorname')),
                ('rechnungsadresse_nachname', models.CharField(blank=True, default='', max_length=50, verbose_name='Nachname')),
                ('rechnungsadresse_firma', models.CharField(blank=True, default='', max_length=50, verbose_name='Firma')),
                ('rechnungsadresse_adresszeile1', models.CharField(blank=True, default='', help_text='Strasse und Hausnummer oder "Postfach"', max_length=50, verbose_name='Adresszeile 1')),
                ('rechnungsadresse_adresszeile2', models.CharField(blank=True, default='', help_text='Nicht verwenden!', max_length=50, verbose_name='Adresszeile 2')),
                ('rechnungsadresse_ort', models.CharField(blank=True, default='', max_length=50, verbose_name='Ort')),
                ('rechnungsadresse_kanton', models.CharField(blank=True, default='', max_length=50, verbose_name='Kanton')),
                ('rechnungsadresse_plz', models.CharField(blank=True, default='', max_length=50, verbose_name='Postleitzahl')),
                ('rechnungsadresse_land', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('rechnungsadresse_email', models.EmailField(blank=True, max_length=254, verbose_name='E-Mail Adresse')),
                ('rechnungsadresse_telefon', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('lieferadresse_vorname', models.CharField(blank=True, default='', max_length=50, verbose_name='Vorname')),
                ('lieferadresse_nachname', models.CharField(blank=True, default='', max_length=50, verbose_name='Nachname')),
                ('lieferadresse_firma', models.CharField(blank=True, default='', max_length=50, verbose_name='Firma')),
                ('lieferadresse_adresszeile1', models.CharField(blank=True, default='', max_length=50, verbose_name='Adresszeile 1')),
                ('lieferadresse_adresszeile2', models.CharField(blank=True, default='', max_length=50, verbose_name='Adresszeile 2')),
                ('lieferadresse_ort', models.CharField(blank=True, default='', max_length=50, verbose_name='Ort')),
                ('lieferadresse_kanton', models.CharField(blank=True, default='', max_length=50, verbose_name='Kanton')),
                ('lieferadresse_plz', models.CharField(blank=True, default='', max_length=50, verbose_name='Postleitzahl')),
                ('lieferadresse_land', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('registrierungsemail_gesendet', models.BooleanField(default=False, verbose_name='Registrierungsemail gesendet?')),
            ],
            options={
                'verbose_name': 'Kunde',
                'verbose_name_plural': 'Kunden',
            },
        ),
        migrations.CreateModel(
            name='Lieferant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('kuerzel', models.CharField(max_length=5, verbose_name='Kürzel')),
                ('name', models.CharField(max_length=50, verbose_name='Name')),
                ('webseite', models.URLField(blank=True, verbose_name='Webseite')),
                ('telefon', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='E-Mail')),
                ('adresse', models.TextField(blank=True, default='', verbose_name='Adresse')),
                ('notiz', models.TextField(blank=True, default='', verbose_name='Notiz')),
                ('ansprechpartner', models.CharField(blank=True, default='', max_length=250, verbose_name='Ansprechpartner')),
                ('ansprechpartnertel', models.CharField(blank=True, default='', max_length=50, verbose_name='Ansprechpartner Telefon')),
                ('ansprechpartnermail', models.EmailField(blank=True, default='', max_length=254, null=True, verbose_name='Ansprechpartner E-Mail')),
            ],
            options={
                'verbose_name': 'Lieferant',
                'verbose_name_plural': 'Lieferanten',
            },
        ),
        migrations.CreateModel(
            name='Lieferung',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default=kmuhelper.modules.main.models.default_delivery_title, max_length=50, verbose_name='Name')),
                ('datum', models.DateField(auto_now_add=True, verbose_name='Erfasst am')),
                ('notiz', models.TextField(blank=True, default='', verbose_name='Notiz')),
                ('eingelagert', models.BooleanField(default=False, verbose_name='Eingelagert')),
                ('lieferant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.Lieferant')),
            ],
            options={
                'verbose_name': 'Lieferung',
                'verbose_name_plural': 'Lieferungen',
            },
        ),
        migrations.CreateModel(
            name='Produkt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('woocommerceid', models.IntegerField(default=0, verbose_name='WooCommerce ID')),
                ('artikelnummer', models.CharField(max_length=25, verbose_name='Artikelnummer')),
                ('name', models.CharField(max_length=250, verbose_name='Name')),
                ('kurzbeschrieb', models.TextField(blank=True, default='', verbose_name='Kurzbeschrieb')),
                ('beschrieb', models.TextField(blank=True, default='', verbose_name='Beschrieb')),
                ('mengenbezeichnung', models.CharField(blank=True, default='Stück', max_length=20, verbose_name='Mengenbezeichnung')),
                ('verkaufspreis', models.FloatField(default=0, verbose_name='Normalpreis in CHF (exkl. MwSt)')),
                ('mwstsatz', models.FloatField(choices=[(7.7, '7.7% (Normalsatz)'), (3.7, '3.7% (Sondersatz für Beherbergungsdienstleistungen)'), (2.5, '2.5% (Reduzierter Satz)')], default=7.7, verbose_name='Mehrwertsteuersatz')),
                ('lagerbestand', models.IntegerField(default=0, verbose_name='Lagerbestand')),
                ('bemerkung', models.TextField(blank=True, default='', verbose_name='Bemerkung')),
                ('packlistenbemerkung', models.TextField(blank=True, default='', verbose_name='Packlistenbemerkung')),
                ('aktion_von', models.DateTimeField(blank=True, null=True, verbose_name='In Aktion von')),
                ('aktion_bis', models.DateTimeField(blank=True, null=True, verbose_name='In Aktion bis')),
                ('aktion_preis', models.FloatField(blank=True, null=True, verbose_name='Aktionspreis in CHF (exkl. MwSt)')),
                ('datenblattlink', models.CharField(blank=True, default='', max_length=500, verbose_name='Datenblattlink')),
                ('bildlink', models.URLField(blank=True, default='', verbose_name='Bildlink')),
                ('lieferant_preis', models.CharField(blank=True, default='', max_length=20, verbose_name='Lieferantenpreis')),
                ('lieferant_artikelnummer', models.CharField(blank=True, default='', max_length=25, verbose_name='Lieferantenartikelnummer')),
            ],
            options={
                'verbose_name': 'Produkt',
                'verbose_name_plural': 'Produkte',
            },
        ),
        migrations.CreateModel(
            name='Zahlungsempfaenger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('qriban', models.CharField(max_length=26, validators=[django.core.validators.RegexValidator('^CH[0-9]{2}\\s3[0-9]{3}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{1}$', 'Bite benutze folgendes Format: CHxx 3xxx xxxx xxxx xxxx x')], verbose_name='QR-IBAN')),
                ('logourl', models.URLField(validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z\\-\\.\\|\\?\\(\\)\\*\\+&"\'_:;/]+\\.(png|jpg)$', 'Nur folgende Zeichen gestattet: 0-9a-zA-Z-_.:;/|?&()"\'*+ - Muss auf .jpg/.png enden.')], verbose_name='Logo (URL)')),
                ('firmenname', models.CharField(max_length=70, verbose_name='Firmennname')),
                ('firmenuid', models.CharField(max_length=15, validators=[django.core.validators.RegexValidator('^CHE-[0-9]{3}\\.[0-9]{3}\\.[0-9]{3}$', 'Bite benutze folgendes Format: CHE-123.456.789')], verbose_name='Firmen-UID')),
                ('adresszeile1', models.CharField(max_length=70, verbose_name='Strasse und Hausnummer oder Postfach')),
                ('adresszeile2', models.CharField(max_length=70, verbose_name='PLZ und Ort')),
                ('land', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('email', models.EmailField(blank=True, default='', help_text='Nicht auf der Rechnung ersichtlich', max_length=254, verbose_name='E-Mail')),
                ('telefon', models.CharField(blank=True, default='', help_text='Nicht auf der Rechnung ersichtlich', max_length=70, verbose_name='Telefon')),
                ('webseite', models.URLField(verbose_name='Webseite')),
            ],
            options={
                'verbose_name': 'Zahlungsempfänger',
                'verbose_name_plural': 'Zahlungsempfänger',
            },
        ),
        migrations.CreateModel(
            name='Produktkategorie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('kategorie', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.Kategorie')),
                ('produkt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.Produkt')),
            ],
            options={
                'verbose_name': 'Produktkategorie',
                'verbose_name_plural': 'Produktkategorien',
            },
        ),
        migrations.AddField(
            model_name='produkt',
            name='kategorien',
            field=models.ManyToManyField(through='kmuhelper.Produktkategorie', to='kmuhelper.Kategorie', verbose_name='Kategorie'),
        ),
        migrations.AddField(
            model_name='produkt',
            name='lieferant',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.Lieferant', verbose_name='Lieferant'),
        ),
        migrations.CreateModel(
            name='Lieferungsposten',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('menge', models.IntegerField(default=1, verbose_name='Menge')),
                ('lieferung', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.Lieferung')),
                ('produkt', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.Produkt')),
            ],
            options={
                'verbose_name': 'Lieferungsposten',
                'verbose_name_plural': 'Lieferungsposten',
            },
        ),
        migrations.AddField(
            model_name='lieferung',
            name='produkte',
            field=models.ManyToManyField(through='kmuhelper.Lieferungsposten', to='kmuhelper.Produkt'),
        ),
        migrations.CreateModel(
            name='Bestellungsposten',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bemerkung', models.CharField(blank=True, default='', help_text='Wird auf die Rechnung gedruckt.', max_length=250, verbose_name='Bemerkung')),
                ('menge', models.IntegerField(default=1, verbose_name='Menge')),
                ('produktpreis', models.FloatField(default=0.0, verbose_name='Produktpreis in CHF (exkl. MwSt)')),
                ('bestellung', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.Bestellung')),
                ('produkt', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.Produkt')),
            ],
            options={
                'verbose_name': 'Bestellungsposten',
                'verbose_name_plural': 'Bestellungsposten',
            },
        ),
        migrations.CreateModel(
            name='Bestellungskosten',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bemerkung', models.CharField(blank=True, default='', help_text='Wird auf die Rechnung gedruckt.', max_length=250, verbose_name='Bemerkung')),
                ('bestellung', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.Bestellung')),
                ('kosten', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.Kosten')),
            ],
            options={
                'verbose_name': 'Bestellungskosten',
                'verbose_name_plural': 'Bestellungskosten',
            },
        ),
        migrations.AddField(
            model_name='bestellung',
            name='kosten',
            field=models.ManyToManyField(through='kmuhelper.Bestellungskosten', to='kmuhelper.Kosten'),
        ),
        migrations.AddField(
            model_name='bestellung',
            name='kunde',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.Kunde'),
        ),
        migrations.AddField(
            model_name='bestellung',
            name='produkte',
            field=models.ManyToManyField(through='kmuhelper.Bestellungsposten', to='kmuhelper.Produkt'),
        ),
        migrations.AddField(
            model_name='bestellung',
            name='zahlungsempfaenger',
            field=models.ForeignKey(default=kmuhelper.modules.main.models.default_payment_recipient, on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.Zahlungsempfaenger', verbose_name='Zahlungsempfänger'),
        ),
    ]
