# Generated by Django 3.2 on 2021-04-12 23:01

from django.db import migrations, models
import django.db.models.deletion
import kmuhelper.modules.emails.models
import kmuhelper.external.multi_email_field.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('kmuhelper', '0057_auto_20210412_1633'),
    ]

    operations = [
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filename', models.CharField(max_length=50, verbose_name='Dateiname')),
                ('file', models.FileField(upload_to=kmuhelper.modules.emails.models.getfilepath, verbose_name='Datei')),
                ('description', models.TextField(blank=True, default='', verbose_name='Beschreibung')),
                ('autocreated', models.BooleanField(default=False, verbose_name='Automatisch generiert')),
                ('token', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='Token')),
                ('time_created', models.DateTimeField(auto_now_add=True, verbose_name='Erstellt um')),
            ],
            options={
                'verbose_name': 'Anhang',
                'verbose_name_plural': 'Anhänge',
                'default_permissions': ('add', 'change', 'view', 'delete', 'download'),
            },
        ),
        migrations.RemoveField(
            model_name='email',
            name='data',
        ),
        migrations.AddField(
            model_name='email',
            name='bcc',
            field=kmuhelper.external.multi_email_field.fields.MultiEmailField(blank=True, default='', verbose_name='BCC'),
        ),
        migrations.AddField(
            model_name='email',
            name='cc',
            field=kmuhelper.external.multi_email_field.fields.MultiEmailField(blank=True, default='', verbose_name='CC'),
        ),
        migrations.AlterField(
            model_name='email',
            name='to',
            field=kmuhelper.external.multi_email_field.fields.MultiEmailField(default=[], verbose_name='Empfänger'),
        ),
        migrations.CreateModel(
            name='EMailAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attachment', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='emails', to='kmuhelper.attachment')),
                ('email', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.email')),
            ],
            options={
                'verbose_name': 'E-Mail Anhang',
                'verbose_name_plural': 'E-Mail Anhänge',
            },
        ),
        migrations.AddField(
            model_name='email',
            name='attachments',
            field=models.ManyToManyField(through='kmuhelper.EMailAttachment', to='kmuhelper.Attachment'),
        ),
    ]
