# Generated by Django 4.1 on 2023-01-27 17:34

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("kmuhelper", "0080_auto_20220311_2125"),
    ]

    operations = [
        migrations.AddField(
            model_name="zahlungsempfaenger",
            name="iban",
            field=models.CharField(
                blank=True,
                default="",
                help_text="IBAN mit Leerzeichen (Nur verwendet im Modus 'Ohne Referenz')",
                max_length=26,
                validators=[
                    django.core.validators.RegexValidator(
                        "^(CH|LI)[0-9]{2}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{1}$",
                        "Bite benutze folgendes Format: (CH|LI)pp 3xxx xxxx xxxx xxxx x",
                    )
                ],
                verbose_name="IBAN",
            ),
        ),
        migrations.AddField(
            model_name="zahlungsempfaenger",
            name="mode",
            field=models.CharField(
                choices=[("QRR", "QR-Referenz"), ("NON", "Ohne Referenz")],
                default="QRR",
                max_length=15,
                verbose_name="Modus",
            ),
        ),
        migrations.AlterField(
            model_name="zahlungsempfaenger",
            name="firmenname",
            field=models.CharField(
                help_text="Name der Firma oder des Empfängers",
                max_length=70,
                verbose_name="Firmennname",
            ),
        ),
        migrations.AlterField(
            model_name="zahlungsempfaenger",
            name="firmenuid",
            field=models.CharField(
                blank=True,
                default="",
                help_text="UID der Firma - Format: CHE-123.456.789 (Mehrwertsteuernummer)",
                max_length=15,
                validators=[
                    django.core.validators.RegexValidator(
                        "^CHE-[0-9]{3}\\.[0-9]{3}\\.[0-9]{3}$",
                        "Bite benutze folgendes Format: CHE-123.456.789",
                    )
                ],
                verbose_name="Firmen-UID",
            ),
        ),
        migrations.AlterField(
            model_name="zahlungsempfaenger",
            name="logourl",
            field=models.URLField(
                blank=True,
                default="",
                help_text="URL eines Bildes (.jpg/.png) - Wird auf die Rechnung gedruckt.",
                validators=[
                    django.core.validators.RegexValidator(
                        "^[0-9a-zA-Z\\-\\.\\|\\?\\(\\)\\*\\+&\"'_:;/]+\\.(png|jpg)$",
                        "Nur folgende Zeichen gestattet: 0-9a-zA-Z-_.:;/|?&()\"'*+ - Muss auf .jpg/.png enden.",
                    )
                ],
                verbose_name="Logo (URL)",
            ),
        ),
        migrations.AlterField(
            model_name="zahlungsempfaenger",
            name="qriban",
            field=models.CharField(
                blank=True,
                default="",
                help_text="QR-IBAN mit Leerzeichen (Nur verwendet im Modus 'QR-Referenz')",
                max_length=26,
                validators=[
                    django.core.validators.RegexValidator(
                        "^(CH|LI)[0-9]{2}\\s3[0-9]{3}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{1}$",
                        "Bite benutze folgendes Format: (CH|LI)pp 3xxx xxxx xxxx xxxx x",
                    )
                ],
                verbose_name="QR-IBAN",
            ),
        ),
    ]
