# Generated by Django 4.1 on 2023-01-28 01:04

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion

def migrate_bestellungskosten(apps, schema_editor):
    Bestellungskosten = apps.get_model("kmuhelper", "bestellungskosten")
    db_alias = schema_editor.connection.alias
    for bek in Bestellungskosten.objects.using(db_alias).all():
        bek.name = bek.kosten.name
        bek.preis = bek.preis or bek.kosten.preis
        bek.mwstsatz = bek.kosten.mwstsatz
        bek.save()

class Migration(migrations.Migration):

    dependencies = [
        ("kmuhelper", "0081_zahlungsempfaenger_iban_zahlungsempfaenger_mode_and_more"),
    ]

    operations = [
        migrations.RenameField(
            model_name="bestellungskosten",
            old_name="kostenpreis",
            new_name="preis",
        ),
        migrations.AddField(
            model_name="bestellungskosten",
            name="mwstsatz",
            field=models.FloatField(
                choices=[
                    (0.0, "0.0% (Mehrwertsteuerfrei)"),
                    (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                    (2.6, "2.6% (Ab 2024: Reduzierter Satz)"),
                    (
                        3.7,
                        "3.7% (Bis 2023: Sondersatz für Beherbergung)",
                    ),
                    (
                        3.8,
                        "3.8% (Ab 2024: Sondersatz für Beherbergung)",
                    ),
                    (7.7, "7.7% (Bis 2023: Normalsatz)"),
                    (8.1, "8.1% (Ab 2024: Normalsatz)"),
                ],
                default=7.7,
                verbose_name="MwSt-Satz",
            ),
        ),
        migrations.AddField(
            model_name="bestellungskosten",
            name="name",
            field=models.CharField(
                default="Zusätzliche Kosten", max_length=500, verbose_name="Name"
            ),
        ),
        migrations.AlterField(
            model_name="bestellungskosten",
            name="kosten",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="kmuhelper.kosten",
            ),
        ),
        migrations.AlterField(
            model_name="bestellungskosten",
            name="rabatt",
            field=models.FloatField(
                default=0.0,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
                verbose_name="Rabatt in %",
            ),
        ),
        migrations.AlterField(
            model_name="kosten",
            name="mwstsatz",
            field=models.FloatField(
                choices=[
                    (0.0, "0.0% (Mehrwertsteuerfrei)"),
                    (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                    (2.6, "2.6% (Ab 2024: Reduzierter Satz)"),
                    (
                        3.7,
                        "3.7% (Bis 2023: Sondersatz für Beherbergung)",
                    ),
                    (
                        3.8,
                        "3.8% (Ab 2024: Sondersatz für Beherbergung)",
                    ),
                    (7.7, "7.7% (Bis 2023: Normalsatz)"),
                    (8.1, "8.1% (Ab 2024: Normalsatz)"),
                ],
                default=7.7,
                verbose_name="MwSt-Satz",
            ),
        ),
        migrations.AlterField(
            model_name="produkt",
            name="mwstsatz",
            field=models.FloatField(
                choices=[
                    (0.0, "0.0% (Mehrwertsteuerfrei)"),
                    (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                    (2.6, "2.6% (Ab 2024: Reduzierter Satz)"),
                    (
                        3.7,
                        "3.7% (Bis 2023: Sondersatz für Beherbergung)",
                    ),
                    (
                        3.8,
                        "3.8% (Ab 2024: Sondersatz für Beherbergung)",
                    ),
                    (7.7, "7.7% (Bis 2023: Normalsatz)"),
                    (8.1, "8.1% (Ab 2024: Normalsatz)"),
                ],
                default=7.7,
                verbose_name="Mehrwertsteuersatz",
            ),
        ),
        migrations.RunPython(migrate_bestellungskosten, migrations.RunPython.noop, elidable=True),
    ]
