# Generated by Django 4.1.6 on 2023-02-17 15:20

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import kmuhelper.modules.main.models


class Migration(migrations.Migration):

    dependencies = [
        ('kmuhelper', '0097_email_language_alter_bestellung_cached_sum_and_more'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='app_zahlungseingang',
            options={'default_permissions': ('add', 'change', 'view'), 'verbose_name': 'Bestellung', 'verbose_name_plural': 'Bestellungen'},
        ),
        migrations.AlterField(
            model_name='bestellung',
            name='cached_sum',
            field=models.FloatField(default=0.0, verbose_name='Total in CHF'),
        ),
        migrations.AlterField(
            model_name='bestellung',
            name='customer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='orders', to='kmuhelper.kunde'),
        ),
        migrations.AlterField(
            model_name='bestellung',
            name='is_paid',
            field=models.BooleanField(default=False, help_text='Mehr Infos -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#was-passiert-wenn-ich-eine-bestellung-als-bezahltversendet-markiere">FAQ</a>', verbose_name='Bezahlt?'),
        ),
        migrations.AlterField(
            model_name='bestellung',
            name='is_removed_from_stock',
            field=models.BooleanField(default=False, verbose_name='Ausgelagert?'),
        ),
        migrations.AlterField(
            model_name='bestellung',
            name='is_shipped',
            field=models.BooleanField(default=False, help_text='Mehr Infos -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#was-passiert-wenn-ich-eine-bestellung-als-bezahltversendet-markiere">FAQ</a>', verbose_name='Versendet?'),
        ),
        migrations.AlterField(
            model_name='bestellung',
            name='payment_conditions',
            field=models.CharField(default=kmuhelper.modules.main.models.default_payment_conditions, help_text='Skonto und Zahlungsfrist -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#wie-funktionieren-zahlungskonditionen">FAQ</a>', max_length=16, validators=[django.core.validators.RegexValidator('^([0-9]+(\\.[0-9]+)?:[0-9]+;)*0:[0-9]+$', "Bitte benutze folgendes Format: 'p:d;p:d' - p = Skonto in %; d = Tage")], verbose_name='Zahlungskonditionen'),
        ),
        migrations.AlterField(
            model_name='bestellung',
            name='pdf_text',
            field=models.TextField(blank=True, default='', editable=False),
        ),
        migrations.AlterField(
            model_name='bestellung',
            name='pdf_title',
            field=models.CharField(blank=True, default='', editable=False, max_length=32),
        ),
        migrations.AlterField(
            model_name='kosten',
            name='name',
            field=models.CharField(default='Zusätzliche Kosten', help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'", max_length=500, verbose_name='Bezeichnung'),
        ),
        migrations.AlterField(
            model_name='lieferant',
            name='contact_person_email',
            field=models.EmailField(blank=True, default='', max_length=254, null=True, verbose_name='E-Mail'),
        ),
        migrations.AlterField(
            model_name='lieferant',
            name='contact_person_name',
            field=models.CharField(blank=True, default='', max_length=250, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='lieferant',
            name='contact_person_phone',
            field=models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon'),
        ),
        migrations.AlterField(
            model_name='lieferung',
            name='is_added_to_stock',
            field=models.BooleanField(default=False, verbose_name='Eingelagert?'),
        ),
        migrations.AlterField(
            model_name='notiz',
            name='done',
            field=models.BooleanField(default=False, verbose_name='Erledigt?'),
        ),
        migrations.AlterField(
            model_name='notiz',
            name='linked_customer',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='linked_note', to='kmuhelper.kunde'),
        ),
        migrations.AlterField(
            model_name='notiz',
            name='linked_delivery',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='linked_note', to='kmuhelper.lieferung'),
        ),
        migrations.AlterField(
            model_name='notiz',
            name='linked_order',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='linked_note', to='kmuhelper.bestellung'),
        ),
        migrations.AlterField(
            model_name='notiz',
            name='linked_product',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='linked_note', to='kmuhelper.produkt'),
        ),
        migrations.AlterField(
            model_name='produkt',
            name='categories',
            field=models.ManyToManyField(related_name='products', through='kmuhelper.ProduktProduktkategorieVerbindung', to='kmuhelper.produktkategorie', verbose_name='Kategorien'),
        ),
        migrations.AlterField(
            model_name='produkt',
            name='lieferant_preis',
            field=models.CharField(blank=True, default='', max_length=20, verbose_name='Einkaufspreis'),
        ),
        migrations.AlterField(
            model_name='produkt',
            name='vat_rate',
            field=models.FloatField(choices=[(0.0, '0.0% (Mehrwertsteuerfrei)'), (2.5, '2.5% (Bis 2023: Reduzierter Satz)'), (2.6, '2.6% (Ab 2024: Reduzierter Satz)'), (3.7, '3.7% (Bis 2023: Sondersatz für Beherbergung)'), (3.8, '3.8% (Ab 2024: Sondersatz für Beherbergung)'), (7.7, '7.7% (Bis 2023: Normalsatz)'), (8.1, '8.1% (Ab 2024: Normalsatz)')], default=7.7, verbose_name='MwSt-Satz'),
        ),
        migrations.AlterField(
            model_name='produktkategorie',
            name='name',
            field=models.CharField(default='', max_length=250, verbose_name='Bezeichnung'),
        ),
        migrations.AlterField(
            model_name='zahlungsempfaenger',
            name='name',
            field=models.CharField(help_text='Name der Firma oder des Empfängers', max_length=70, verbose_name='Name'),
        ),
    ]
