# Generated by Django 4.1.6 on 2023-02-20 18:31

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import kmuhelper.external.multi_email_field.fields
import kmuhelper.modules.emails.models
import kmuhelper.modules.main.models
import uuid

""" Important note!

This migration is a squashed migration. It technically contains all the migrations from 0001 to 0100.

This file has only partially been generated by squashing the migrations with the `manage.py squashmigrations 100` command.
It has been mainly generated by removing all the old migrations and then running `manage.py makemigrations`.

Reason for this "fake squashing" is that squashmigrations did not work properly and still left some
CreateModel, DeleteModel and RenameField operations in the squashed migration.

I am aware that this is not the proper way to squash migrations, but it is the only way I could get it to work.

- Rafael, 2023-02-20
"""

class Migration(migrations.Migration):

    replaces = [('kmuhelper', '0001_initial'), ('kmuhelper', '0002_auto_20200426_1746'), ('kmuhelper', '0003_auto_20200426_1820'), ('kmuhelper', '0004_kunde_zusammenfuegen'), ('kmuhelper', '0005_auto_20200427_1857'), ('kmuhelper', '0006_auto_20200428_1711'), ('kmuhelper', '0007_auto_20200502_1530'), ('kmuhelper', '0008_auto_20200502_1851'), ('kmuhelper', '0009_kunde_notiz'), ('kmuhelper', '0010_kunde_webseite'), ('kmuhelper', '0011_kunde_firma'), ('kmuhelper', '0012_auto_20200603_0859'), ('kmuhelper', '0013_auto_20200603_0910'), ('kmuhelper', '0014_auto_20200603_0927'), ('kmuhelper', '0015_bestellung_fix_summe'), ('kmuhelper', '0016_auto_20200627_1641'), ('kmuhelper', '0017_todoentry'), ('kmuhelper', '0018_auto_20200715_1639'), ('kmuhelper', '0019_auto_20200715_1931'), ('kmuhelper', '0020_auto_20200716_1443'), ('kmuhelper', '0021_versandliste'), ('kmuhelper', '0022_auto_20200716_1534'), ('kmuhelper', '0023_auto_20200716_1553'), ('kmuhelper', '0024_auto_20200716_1714'), ('kmuhelper', '0025_auto_20200716_2126'), ('kmuhelper', '0026_todolagerbestand_todolieferung'), ('kmuhelper', '0027_auto_20200717_1630'), ('kmuhelper', '0028_auto_20200720_1849'), ('kmuhelper', '0029_notiz_produkt'), ('kmuhelper', '0030_auto_20200720_1936'), ('kmuhelper', '0031_auto_20200727_1603'), ('kmuhelper', '0032_auto_20200802_0018'), ('kmuhelper', '0033_auto_20200802_2105'), ('kmuhelper', '0034_bestellungsposten_rabatt'), ('kmuhelper', '0035_auto_20201003_2125'), ('kmuhelper', '0036_auto_20201005_1353'), ('kmuhelper', '0037_auto_20201005_1423'), ('kmuhelper', '0038_produkt_soll_lagerbestand'), ('kmuhelper', '0039_auto_20201006_1803'), ('kmuhelper', '0040_auto_20201009_2329'), ('kmuhelper', '0041_auto_20201010_1630'), ('kmuhelper', '0042_auto_20201010_1633'), ('kmuhelper', '0043_auto_20201010_1739'), ('kmuhelper', '0044_auto_20201010_1746'), ('kmuhelper', '0045_auto_20201018_1419'), ('kmuhelper', '0046_auto_20201018_1743'), ('kmuhelper', '0047_auto_20201018_1851'), ('kmuhelper', '0048_auto_20210202_2101'), ('kmuhelper', '0049_email_data'), ('kmuhelper', '0050_produkt_lieferant_url'), ('kmuhelper', '0051_apikey'), ('kmuhelper', '0052_bestellung_rechnungsdatum'), ('kmuhelper', '0053_bestellung_rechnungstext'), ('kmuhelper', '0054_auto_20210403_1941'), ('kmuhelper', '0055_auto_20210403_2008'), ('kmuhelper', '0056_auto_20210409_2340'), ('kmuhelper', '0057_auto_20210412_1633'), ('kmuhelper', '0058_auto_20210413_0101'), ('kmuhelper', '0059_alter_email_html_context'), ('kmuhelper', '0060_remove_email_typ'), ('kmuhelper', '0061_auto_20210413_2119'), ('kmuhelper', '0062_email_text'), ('kmuhelper', '0063_help_texts'), ('kmuhelper', '0064_emailtemplate'), ('kmuhelper', '0065_emailtemplate_mail_to'), ('kmuhelper', '0066_auto_20210414_2213'), ('kmuhelper', '0067_auto_20210415_2007'), ('kmuhelper', '0068_rename_registrierungsemail_kunde_email_registriert'), ('kmuhelper', '0069_auto_20210417_2007'), ('kmuhelper', '0070_auto_20210417_2146'), ('kmuhelper', '0071_paymentimport_paymentimportentry'), ('kmuhelper', '0072_auto_20210420_2335'), ('kmuhelper', '0073_auto_20210422_1323'), ('kmuhelper', '0074_alter_bestellung_status'), ('kmuhelper', '0075_einstellung_description'), ('kmuhelper', '0076_alter_bestellung_zahlungskonditionen'), ('kmuhelper', '0077_alter_bestellung_zahlungskonditionen'), ('kmuhelper', '0078_auto_20211122_1926'), ('kmuhelper', '0079_auto_20220305_2322'), ('kmuhelper', '0080_auto_20220311_2125'), ('kmuhelper', '0081_zahlungsempfaenger_iban_zahlungsempfaenger_mode_and_more'), ('kmuhelper', '0082_rename_kostenpreis_bestellungskosten_preis_and_more'), ('kmuhelper', '0083_alter_zahlungsempfaenger_webseite'), ('kmuhelper', '0084_alter_produkt_mengenbezeichnung'), ('kmuhelper', '0085_alter_bestellungskosten_name_alter_kosten_name_and_more'), ('kmuhelper', '0086_rename_produktkategorie'), ('kmuhelper', '0087_bestellung_bezahlt_am_bestellung_versendet_am'), ('kmuhelper', '0088_alter_bestellung_bezahlt_alter_bestellung_versendet_and_more'), ('kmuhelper', '0089_remove_einstellung_description_and_more'), ('kmuhelper', '0090_rename_telefon_ansprechpartner_phone_and_more'), ('kmuhelper', '0091_rename_fix_summe_bestellung_cached_sum_and_more'), ('kmuhelper', '0092_rename_rabatt_bestellungskosten_discount_and_more'), ('kmuhelper', '0093_rename_email_lieferung_bestellung__email_link_invoice_and_more'), ('kmuhelper', '0094_alter_bestellung_cached_sum_alter_bestellung_is_paid_and_more'), ('kmuhelper', '0095_rename_erstellt_am_notiz_created_at_and_more'), ('kmuhelper', '0096_rename_email_registriert_kunde_email_link_registered_and_more'), ('kmuhelper', '0097_email_language_alter_bestellung_cached_sum_and_more'), ('kmuhelper', '0098_alter_app_zahlungseingang_options_and_more'), ('kmuhelper', '0099_order_orderfee_orderitem_product_and_more'), ('kmuhelper', '0100_app_arrival_app_incomingpayments_app_shipping_and_more')]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filename', models.CharField(max_length=50, verbose_name='Dateiname')),
                ('file', models.FileField(upload_to=kmuhelper.modules.emails.models.getfilepath, verbose_name='Datei')),
                ('description', models.TextField(blank=True, default='', verbose_name='Beschreibung')),
                ('autocreated', models.BooleanField(default=False, verbose_name='Automatisch generiert')),
                ('token', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='Token')),
                ('time_created', models.DateTimeField(auto_now_add=True, verbose_name='Erstellt um')),
            ],
            options={
                'verbose_name': 'Anhang',
                'verbose_name_plural': 'Anhänge',
                'default_permissions': ('add', 'change', 'view', 'delete', 'download'),
            },
        ),
        migrations.CreateModel(
            name='ContactPerson',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Auf Rechnung ersichtlich!', max_length=50, verbose_name='Name')),
                ('phone', models.CharField(help_text='Auf Rechnung ersichtlich!', max_length=50, verbose_name='Telefon')),
                ('email', models.EmailField(help_text='Auf Rechnung ersichtlich!', max_length=254, verbose_name='E-Mail')),
            ],
            options={
                'verbose_name': 'Ansprechpartner',
                'verbose_name_plural': 'Ansprechpartner',
            },
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('woocommerceid', models.IntegerField(default=0, verbose_name='WooCommerce ID')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='E-Mail Adresse')),
                ('first_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Vorname')),
                ('last_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Nachname')),
                ('company', models.CharField(blank=True, default='', max_length=250, verbose_name='Firma')),
                ('username', models.CharField(blank=True, default='', max_length=50, verbose_name='Benutzername')),
                ('avatar_url', models.URLField(blank=True, editable=False, verbose_name='Avatar URL')),
                ('language', models.CharField(choices=[('de', 'Deutsch [DE]'), ('fr', 'Französisch [FR]'), ('it', 'Italienisch [IT]'), ('en', 'Englisch [EN]')], default='de', max_length=2, verbose_name='Sprache')),
                ('addr_billing_first_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Vorname')),
                ('addr_billing_last_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Nachname')),
                ('addr_billing_company', models.CharField(blank=True, default='', max_length=250, verbose_name='Firma')),
                ('addr_billing_address_1', models.CharField(blank=True, default='', help_text='Strasse und Hausnummer oder "Postfach"', max_length=250, verbose_name='Adresszeile 1')),
                ('addr_billing_address_2', models.CharField(blank=True, default='', help_text='Wird in QR-Rechnung NICHT verwendet!', max_length=250, verbose_name='Adresszeile 2')),
                ('addr_billing_city', models.CharField(blank=True, default='', max_length=250, verbose_name='Ort')),
                ('addr_billing_state', models.CharField(blank=True, default='', max_length=50, verbose_name='Kanton')),
                ('addr_billing_postcode', models.CharField(blank=True, default='', max_length=50, verbose_name='Postleitzahl')),
                ('addr_billing_country', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('addr_billing_email', models.EmailField(blank=True, max_length=254, verbose_name='E-Mail Adresse')),
                ('addr_billing_phone', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('addr_shipping_first_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Vorname')),
                ('addr_shipping_last_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Nachname')),
                ('addr_shipping_company', models.CharField(blank=True, default='', max_length=250, verbose_name='Firma')),
                ('addr_shipping_address_1', models.CharField(blank=True, default='', max_length=250, verbose_name='Adresszeile 1')),
                ('addr_shipping_address_2', models.CharField(blank=True, default='', max_length=250, verbose_name='Adresszeile 2')),
                ('addr_shipping_city', models.CharField(blank=True, default='', max_length=250, verbose_name='Ort')),
                ('addr_shipping_state', models.CharField(blank=True, default='', max_length=50, verbose_name='Kanton')),
                ('addr_shipping_postcode', models.CharField(blank=True, default='', max_length=50, verbose_name='Postleitzahl')),
                ('addr_shipping_country', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('addr_shipping_email', models.EmailField(blank=True, max_length=254, verbose_name='E-Mail Adresse')),
                ('addr_shipping_phone', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('website', models.URLField(blank=True, default='', verbose_name='Webseite')),
                ('note', models.TextField(blank=True, default='', verbose_name='Bemerkung')),
                ('combine_with', models.ForeignKey(blank=True, help_text='Dies kann nicht widerrufen werden! Werte im aktuellen Kunden werden bevorzugt.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.customer', verbose_name='Zusammenfügen mit')),
            ],
            options={
                'verbose_name': 'Kunde',
                'verbose_name_plural': 'Kunden',
            },
        ),
        migrations.CreateModel(
            name='EMail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(help_text='Wird Standardmässig auch als Untertitel verwendet.', max_length=50, verbose_name='Betreff')),
                ('to', kmuhelper.external.multi_email_field.fields.MultiEmailField(default=[], help_text='Direkte Empfänger', verbose_name='Empfänger')),
                ('cc', kmuhelper.external.multi_email_field.fields.MultiEmailField(blank=True, default='', help_text='Kopie', verbose_name='CC')),
                ('bcc', kmuhelper.external.multi_email_field.fields.MultiEmailField(blank=True, default='', help_text='Blindkopie', verbose_name='BCC')),
                ('language', models.CharField(choices=[('de', 'Deutsch [DE]'), ('fr', 'Französisch [FR]'), ('it', 'Italienisch [IT]'), ('en', 'Englisch [EN]')], default='de', max_length=2, verbose_name='Sprache')),
                ('html_template', models.CharField(default='default.html', help_text="Dateiname der Designvorlage unter 'kmuhelper/emails/'.", max_length=50, verbose_name='Designvorlage')),
                ('text', models.TextField(blank=True, default='', help_text='Hauptinhalt - wird nicht von allen Designvorlagen verwendet. Links und E-Mail Adressen werden automatisch verlinkt.', verbose_name='Text')),
                ('html_context', models.JSONField(blank=True, default=dict, help_text='Daten im JSON-Format, mit welchen die Designvorlage befüllt wird.', null=True, verbose_name='Daten')),
                ('token', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='Token')),
                ('time_created', models.DateTimeField(auto_now_add=True, help_text='Datum und Zeit der Erstellung dieser E-Mail.', verbose_name='Erstellt am')),
                ('time_sent', models.DateTimeField(blank=True, default=None, help_text='Datum und Zeit des letzten erfolgreichen Sendeversuches.', null=True, verbose_name='Gesendet um')),
                ('sent', models.BooleanField(default=False, verbose_name='Gesendet?')),
                ('notes', models.TextField(blank=True, default='', help_text='Diese Notizen haben keine Einwirkung auf die E-Mail selbst.', verbose_name='Notizen')),
            ],
            options={
                'verbose_name': 'E-Mail',
                'verbose_name_plural': 'E-Mails',
                'default_permissions': ('add', 'change', 'view', 'delete', 'send'),
            },
        ),
        migrations.CreateModel(
            name='EMailTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='Titel')),
                ('description', models.TextField(blank=True, default='', verbose_name='Beschreibung')),
                ('mail_to', models.CharField(blank=True, default='', max_length=50, verbose_name='Empfänger')),
                ('mail_subject', models.CharField(max_length=50, verbose_name='Betreff')),
                ('mail_text', models.TextField(verbose_name='Text')),
                ('mail_template', models.CharField(default='default.html', max_length=50, verbose_name='Designvorlage')),
                ('mail_context', models.JSONField(blank=True, default=dict, null=True, verbose_name='Daten')),
            ],
            options={
                'verbose_name': 'E-Mail-Vorlage',
                'verbose_name_plural': 'E-Mail-Vorlagen',
            },
        ),
        migrations.CreateModel(
            name='Fee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='Zusätzliche Kosten', help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'", max_length=500, verbose_name='Bezeichnung')),
                ('price', models.FloatField(default=0.0, verbose_name='Preis (exkl. MwSt)')),
                ('vat_rate', models.FloatField(choices=[(0.0, '0.0% (Mehrwertsteuerfrei)'), (2.5, '2.5% (Bis 2023: Reduzierter Satz)'), (2.6, '2.6% (Ab 2024: Reduzierter Satz)'), (3.7, '3.7% (Bis 2023: Sondersatz für Beherbergung)'), (3.8, '3.8% (Ab 2024: Sondersatz für Beherbergung)'), (7.7, '7.7% (Bis 2023: Normalsatz)'), (8.1, '8.1% (Ab 2024: Normalsatz)')], default=7.7, verbose_name='MwSt-Satz')),
            ],
            options={
                'verbose_name': 'Kosten',
                'verbose_name_plural': 'Kosten',
            },
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('woocommerceid', models.IntegerField(default=0, verbose_name='WooCommerce ID')),
                ('date', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Datum')),
                ('invoice_date', models.DateField(blank=True, default=None, help_text='Datum der Rechnung. Wird auch als Startpunkt für die Zahlungskonditionen verwendet.', null=True, verbose_name='Rechnungsdatum')),
                ('payment_conditions', models.CharField(default=kmuhelper.modules.main.models.default_payment_conditions, help_text='Skonto und Zahlungsfrist -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#wie-funktionieren-zahlungskonditionen">FAQ</a>', max_length=16, validators=[django.core.validators.RegexValidator('^([0-9]+(\\.[0-9]+)?:[0-9]+;)*0:[0-9]+$', "Bitte benutze folgendes Format: 'p:d;p:d' - p = Skonto in %; d = Tage")], verbose_name='Zahlungskonditionen')),
                ('status', models.CharField(choices=[('pending', 'Zahlung ausstehend'), ('processing', 'In Bearbeitung'), ('on-hold', 'In Wartestellung'), ('completed', 'Abgeschlossen'), ('cancelled', 'Storniert/Abgebrochen'), ('refunded', 'Rückerstattet'), ('failed', 'Fehlgeschlagen'), ('trash', 'Gelöscht')], default='processing', max_length=11, verbose_name='Status')),
                ('is_shipped', models.BooleanField(default=False, help_text='Mehr Infos -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#was-passiert-wenn-ich-eine-bestellung-als-bezahltversendet-markiere">FAQ</a>', verbose_name='Versendet?')),
                ('shipped_on', models.DateField(blank=True, default=None, null=True, verbose_name='Versendet am')),
                ('tracking_number', models.CharField(blank=True, default='', help_text='Bitte gib hier eine Trackingnummer der Schweizer Post ein. (optional)', max_length=25, validators=[django.core.validators.RegexValidator('^99\\.[0-9]{2}\\.[0-9]{6}\\.[0-9]{8}$', 'Bite benutze folgendes Format: 99.xx.xxxxxx.xxxxxxxx')], verbose_name='Trackingnummer')),
                ('is_removed_from_stock', models.BooleanField(default=False, verbose_name='Ausgelagert?')),
                ('payment_method', models.CharField(choices=[('bacs', 'Überweisung'), ('cheque', 'Scheck'), ('cod', 'Rechnung / Nachnahme'), ('paypal', 'PayPal')], default='cod', max_length=7, verbose_name='Zahlungsmethode')),
                ('is_paid', models.BooleanField(default=False, help_text='Mehr Infos -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#was-passiert-wenn-ich-eine-bestellung-als-bezahltversendet-markiere">FAQ</a>', verbose_name='Bezahlt?')),
                ('paid_on', models.DateField(blank=True, default=None, null=True, verbose_name='Bezahlt am')),
                ('customer_note', models.TextField(blank=True, default='', help_text='Vom Kunden erfasste Notiz.', verbose_name='Kundennotiz')),
                ('order_key', models.CharField(blank=True, default=kmuhelper.modules.main.models.default_order_key, max_length=50, verbose_name='Bestellungs-Schlüssel')),
                ('addr_billing_first_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Vorname')),
                ('addr_billing_last_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Nachname')),
                ('addr_billing_company', models.CharField(blank=True, default='', max_length=250, verbose_name='Firma')),
                ('addr_billing_address_1', models.CharField(blank=True, default='', help_text="Strasse und Hausnummer oder 'Postfach'", max_length=250, verbose_name='Adresszeile 1')),
                ('addr_billing_address_2', models.CharField(blank=True, default='', help_text='Wird in QR-Rechnung NICHT verwendet!', max_length=250, verbose_name='Adresszeile 2')),
                ('addr_billing_city', models.CharField(blank=True, default='', max_length=250, verbose_name='Ort')),
                ('addr_billing_state', models.CharField(blank=True, default='', max_length=50, verbose_name='Kanton')),
                ('addr_billing_postcode', models.CharField(blank=True, default='', max_length=50, verbose_name='Postleitzahl')),
                ('addr_billing_country', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('addr_billing_email', models.EmailField(blank=True, max_length=254, verbose_name='E-Mail Adresse')),
                ('addr_billing_phone', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('addr_shipping_first_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Vorname')),
                ('addr_shipping_last_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Nachname')),
                ('addr_shipping_company', models.CharField(blank=True, default='', max_length=250, verbose_name='Firma')),
                ('addr_shipping_address_1', models.CharField(blank=True, default='', max_length=250, verbose_name='Adresszeile 1')),
                ('addr_shipping_address_2', models.CharField(blank=True, default='', max_length=250, verbose_name='Adresszeile 2')),
                ('addr_shipping_city', models.CharField(blank=True, default='', max_length=250, verbose_name='Ort')),
                ('addr_shipping_state', models.CharField(blank=True, default='', max_length=50, verbose_name='Kanton')),
                ('addr_shipping_postcode', models.CharField(blank=True, default='', max_length=50, verbose_name='Postleitzahl')),
                ('addr_shipping_country', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('addr_shipping_email', models.EmailField(blank=True, max_length=254, verbose_name='E-Mail Adresse')),
                ('addr_shipping_phone', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('cached_sum', models.FloatField(default=0.0, verbose_name='Total in CHF')),
                ('pdf_title', models.CharField(blank=True, default='', editable=False, max_length=32)),
                ('pdf_text', models.TextField(blank=True, default='', editable=False)),
                ('contact_person', models.ForeignKey(default=kmuhelper.modules.main.models.default_contact_person, on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.contactperson', verbose_name='Ansprechpartner')),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='orders', to='kmuhelper.customer')),
                ('email_link_invoice', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='kmuhelper.email')),
                ('email_link_shipped', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='kmuhelper.email')),
            ],
            options={
                'verbose_name': 'Bestellung',
                'verbose_name_plural': 'Bestellungen',
            },
        ),
        migrations.CreateModel(
            name='PaymentImport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_imported', models.DateTimeField(auto_now_add=True, verbose_name='Importiert am')),
                ('is_processed', models.BooleanField(default=False, verbose_name='Verarbeitet?')),
                ('data_msgid', models.CharField(max_length=50, verbose_name='Nachrichtenid')),
                ('data_creationdate', models.DateTimeField(verbose_name='Erstellt am')),
            ],
            options={
                'verbose_name': 'Zahlungsimport',
                'verbose_name_plural': 'Zahlungsimporte',
            },
        ),
        migrations.CreateModel(
            name='PaymentReceiver',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mode', models.CharField(choices=[('QRR', 'QR-Referenz'), ('NON', 'Ohne Referenz')], default='QRR', max_length=15, verbose_name='Modus')),
                ('qriban', models.CharField(blank=True, default='', help_text="QR-IBAN mit Leerzeichen (Nur verwendet im Modus 'QR-Referenz')", max_length=26, validators=[django.core.validators.RegexValidator('^(CH|LI)[0-9]{2}\\s3[0-9]{3}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{1}$', 'Bite benutze folgendes Format: (CH|LI)pp 3xxx xxxx xxxx xxxx x')], verbose_name='QR-IBAN')),
                ('iban', models.CharField(blank=True, default='', help_text="IBAN mit Leerzeichen (Nur verwendet im Modus 'Ohne Referenz')", max_length=26, validators=[django.core.validators.RegexValidator('^(CH|LI)[0-9]{2}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{1}$', 'Bite benutze folgendes Format: (CH|LI)pp 3xxx xxxx xxxx xxxx x')], verbose_name='IBAN')),
                ('logourl', models.URLField(blank=True, default='', help_text='URL eines Bildes (.jpg/.png) - Wird auf die Rechnung gedruckt.', validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z\\-\\.\\|\\?\\(\\)\\*\\+&"\'_:;/]+\\.(png|jpg)$', 'Nur folgende Zeichen gestattet: 0-9a-zA-Z-_.:;/|?&()"\'*+ - Muss auf .jpg/.png enden.')], verbose_name='Logo (URL)')),
                ('name', models.CharField(help_text='Name der Firma oder des Empfängers', max_length=70, verbose_name='Name')),
                ('swiss_uid', models.CharField(blank=True, default='', help_text='UID der Firma - Format: CHE-123.456.789 (Mehrwertsteuernummer)', max_length=15, validators=[django.core.validators.RegexValidator('^CHE-[0-9]{3}\\.[0-9]{3}\\.[0-9]{3}$', 'Bite benutze folgendes Format: CHE-123.456.789')], verbose_name='Firmen-UID')),
                ('address_1', models.CharField(max_length=70, verbose_name="Strasse und Hausnummer oder 'Postfach'")),
                ('address_2', models.CharField(max_length=70, verbose_name='PLZ und Ort')),
                ('country', models.CharField(choices=[('CH', 'Schweiz'), ('LI', 'Liechtenstein')], default='CH', max_length=2, verbose_name='Land')),
                ('email', models.EmailField(blank=True, default='', help_text='Nicht auf der Rechnung ersichtlich', max_length=254, verbose_name='E-Mail')),
                ('phone', models.CharField(blank=True, default='', help_text='Nicht auf der Rechnung ersichtlich', max_length=70, verbose_name='Telefon')),
                ('website', models.URLField(blank=True, default='', help_text='Auf der Rechnung ersichtlich, sofern vorhanden!', verbose_name='Webseite')),
            ],
            options={
                'verbose_name': 'Zahlungsempfänger',
                'verbose_name_plural': 'Zahlungsempfänger',
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('article_number', models.CharField(max_length=25, verbose_name='Artikelnummer')),
                ('woocommerceid', models.IntegerField(default=0, verbose_name='WooCommerce ID')),
                ('name', models.CharField(help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'", max_length=500, verbose_name='Name')),
                ('short_description', models.TextField(blank=True, default='', help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'", verbose_name='Kurzbeschrieb')),
                ('description', models.TextField(blank=True, default='', help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'", verbose_name='Beschrieb')),
                ('quantity_description', models.CharField(blank=True, default='Stück', help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'", max_length=100, verbose_name='Mengenbezeichnung')),
                ('selling_price', models.FloatField(default=0, verbose_name='Normalpreis in CHF (exkl. MwSt)')),
                ('vat_rate', models.FloatField(choices=[(0.0, '0.0% (Mehrwertsteuerfrei)'), (2.5, '2.5% (Bis 2023: Reduzierter Satz)'), (2.6, '2.6% (Ab 2024: Reduzierter Satz)'), (3.7, '3.7% (Bis 2023: Sondersatz für Beherbergung)'), (3.8, '3.8% (Ab 2024: Sondersatz für Beherbergung)'), (7.7, '7.7% (Bis 2023: Normalsatz)'), (8.1, '8.1% (Ab 2024: Normalsatz)')], default=7.7, verbose_name='MwSt-Satz')),
                ('stock_current', models.IntegerField(default=0, verbose_name='Lagerbestand')),
                ('stock_target', models.IntegerField(default=1, verbose_name='Soll-Lagerbestand')),
                ('note', models.TextField(blank=True, default='', help_text='Wird nicht gedruckt oder angezeigt; nur für eigene Zwecke.', verbose_name='Bemerkung')),
                ('sale_from', models.DateTimeField(blank=True, null=True, verbose_name='In Aktion von')),
                ('sale_to', models.DateTimeField(blank=True, null=True, verbose_name='In Aktion bis')),
                ('sale_price', models.FloatField(blank=True, null=True, verbose_name='Aktionspreis in CHF (exkl. MwSt)')),
                ('datasheet_url', models.CharField(blank=True, default='', max_length=500, verbose_name='Datenblattlink')),
                ('image_url', models.URLField(blank=True, default='', verbose_name='Bildlink')),
                ('supplier_price', models.CharField(blank=True, default='', max_length=20, verbose_name='Einkaufspreis')),
                ('supplier_article_number', models.CharField(blank=True, default='', max_length=25, verbose_name='Lieferantenartikelnummer')),
                ('supplier_url', models.URLField(blank=True, default='', verbose_name='Lieferantenurl (Für Nachbestellungen)')),
            ],
            options={
                'verbose_name': 'Produkt',
                'verbose_name_plural': 'Produkte',
            },
        ),
        migrations.CreateModel(
            name='ProductCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('woocommerceid', models.IntegerField(default=0, verbose_name='WooCommerce ID')),
                ('name', models.CharField(default='', max_length=250, verbose_name='Bezeichnung')),
                ('description', models.TextField(blank=True, default='', verbose_name='Beschrieb')),
                ('image_url', models.URLField(blank=True, verbose_name='Bildlink')),
                ('parent_category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.productcategory', verbose_name='Übergeordnete Kategorie')),
            ],
            options={
                'verbose_name': 'Produktkategorie',
                'verbose_name_plural': 'Produktkategorien',
            },
        ),
        migrations.CreateModel(
            name='Setting',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False, verbose_name='ID')),
                ('typ', models.CharField(choices=[('char', 'Text'), ('text', 'Mehrzeiliger Text'), ('bool', 'Wahrheitswert'), ('int', 'Zahl'), ('float', 'Fliesskommazahl'), ('url', 'Url'), ('email', 'E-Mail'), ('json', 'JSON Daten')], default='char', max_length=5, verbose_name='Typ')),
                ('content_char', models.CharField(blank=True, default='', max_length=250, verbose_name='Inhalt (Text)')),
                ('content_text', models.TextField(blank=True, default='', verbose_name='Inhalt (Mehrzeiliger Text)')),
                ('content_bool', models.BooleanField(blank=True, default=False, verbose_name='Inhalt (Wahrheitswert)')),
                ('content_int', models.IntegerField(blank=True, default=0, verbose_name='Inhalt (Zahl)')),
                ('content_float', models.FloatField(blank=True, default=0.0, verbose_name='Inhalt (Fliesskommazahl)')),
                ('content_url', models.URLField(blank=True, default='', verbose_name='Inhalt (Url)')),
                ('content_email', models.EmailField(blank=True, default='', max_length=254, verbose_name='Inhalt (E-Mail)')),
                ('content_json', models.JSONField(blank=True, default=dict, null=True, verbose_name='Inhalt (JSON)')),
            ],
            options={
                'verbose_name': 'Einstellung',
                'verbose_name_plural': 'Einstellungen',
            },
        ),
        migrations.CreateModel(
            name='SettingHidden',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False, verbose_name='ID')),
                ('typ', models.CharField(choices=[('char', 'Text'), ('text', 'Mehrzeiliger Text'), ('bool', 'Wahrheitswert'), ('int', 'Zahl'), ('float', 'Fliesskommazahl'), ('url', 'Url'), ('email', 'E-Mail'), ('json', 'JSON Daten')], default='char', max_length=5, verbose_name='Typ')),
                ('content_char', models.CharField(blank=True, default='', max_length=250, verbose_name='Inhalt (Text)')),
                ('content_text', models.TextField(blank=True, default='', verbose_name='Inhalt (Mehrzeiliger Text)')),
                ('content_bool', models.BooleanField(blank=True, default=False, verbose_name='Inhalt (Wahrheitswert)')),
                ('content_int', models.IntegerField(blank=True, default=0, verbose_name='Inhalt (Zahl)')),
                ('content_float', models.FloatField(blank=True, default=0.0, verbose_name='Inhalt (Fliesskommazahl)')),
                ('content_url', models.URLField(blank=True, default='', verbose_name='Inhalt (Url)')),
                ('content_email', models.EmailField(blank=True, default='', max_length=254, verbose_name='Inhalt (E-Mail)')),
                ('content_json', models.JSONField(blank=True, default=dict, null=True, verbose_name='Inhalt (JSON)')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Supplier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('abbreviation', models.CharField(max_length=5, verbose_name='Kürzel')),
                ('name', models.CharField(max_length=50, verbose_name='Name')),
                ('website', models.URLField(blank=True, verbose_name='Webseite')),
                ('phone', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='E-Mail')),
                ('address', models.TextField(blank=True, default='', verbose_name='Adresse')),
                ('note', models.TextField(blank=True, default='', verbose_name='Notiz')),
                ('contact_person_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Name')),
                ('contact_person_phone', models.CharField(blank=True, default='', max_length=50, verbose_name='Telefon')),
                ('contact_person_email', models.EmailField(blank=True, default='', max_length=254, null=True, verbose_name='E-Mail')),
            ],
            options={
                'verbose_name': 'Lieferant',
                'verbose_name_plural': 'Lieferanten',
            },
        ),
        migrations.CreateModel(
            name='Supply',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default=kmuhelper.modules.main.models.default_delivery_title, max_length=50, verbose_name='Name')),
                ('date', models.DateField(auto_now_add=True, verbose_name='Erfasst am')),
                ('is_added_to_stock', models.BooleanField(default=False, verbose_name='Eingelagert?')),
            ],
            options={
                'verbose_name': 'Lieferung',
                'verbose_name_plural': 'Lieferungen',
            },
        ),
        migrations.CreateModel(
            name='SupplyItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.IntegerField(default=1, verbose_name='Menge')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.product', verbose_name='Produkt')),
                ('supply', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.supply')),
            ],
            options={
                'verbose_name': 'Lieferungsposten',
                'verbose_name_plural': 'Lieferungsposten',
            },
        ),
        migrations.AddField(
            model_name='supply',
            name='products',
            field=models.ManyToManyField(through='kmuhelper.SupplyItem', to='kmuhelper.product'),
        ),
        migrations.AddField(
            model_name='supply',
            name='supplier',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.supplier', verbose_name='Lieferant'),
        ),
        migrations.CreateModel(
            name='ProductProductCategoryConnection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.productcategory', verbose_name='Produktkategorie')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.product', verbose_name='Produkt')),
            ],
            options={
                'verbose_name': 'Produkt-Kategorie-Verknüpfung',
                'verbose_name_plural': 'Produkt-Kategorie-Verknüpfungen',
            },
        ),
        migrations.AddField(
            model_name='product',
            name='categories',
            field=models.ManyToManyField(related_name='products', through='kmuhelper.ProductProductCategoryConnection', to='kmuhelper.productcategory', verbose_name='Kategorien'),
        ),
        migrations.AddField(
            model_name='product',
            name='supplier',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.supplier', verbose_name='Lieferant'),
        ),
        migrations.CreateModel(
            name='PaymentImportEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ref', models.CharField(default='', max_length=50, verbose_name='Referenznummer')),
                ('additionalref', models.CharField(default='', max_length=250, verbose_name='Zusätzliche Referenz')),
                ('iban', models.CharField(default='', max_length=22, verbose_name='IBAN')),
                ('name', models.CharField(default='', max_length=250, verbose_name='Name')),
                ('valuedate', models.DateField(null=True, verbose_name='Valuta')),
                ('amount', models.FloatField(verbose_name='Betrag')),
                ('currency', models.CharField(max_length=10, verbose_name='Währung')),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='entries', to='kmuhelper.paymentimport')),
            ],
            options={
                'verbose_name': 'Zahlungsimport-Eintrag',
                'verbose_name_plural': 'Zahlungsimport-Einträge',
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='OrderItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('note', models.CharField(blank=True, default='', help_text='Wird auf die Rechnung gedruckt.', max_length=250, verbose_name='Bemerkung')),
                ('quantity', models.IntegerField(default=1, verbose_name='Menge')),
                ('discount', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)], verbose_name='Rabatt in %')),
                ('product_price', models.FloatField(default=0.0, verbose_name='Produktpreis (exkl. MwSt)')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.order')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.product', verbose_name='Produkt')),
            ],
            options={
                'verbose_name': 'Bestellungsposten',
                'verbose_name_plural': 'Bestellungsposten',
            },
        ),
        migrations.CreateModel(
            name='OrderFee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('note', models.CharField(blank=True, default='', help_text='Wird auf die Rechnung gedruckt.', max_length=250, verbose_name='Bemerkung')),
                ('discount', models.FloatField(default=0.0, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)], verbose_name='Rabatt in %')),
                ('name', models.CharField(default='Zusätzliche Kosten', help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'", max_length=500, verbose_name='Name')),
                ('price', models.FloatField(default=0.0, verbose_name='Preis (exkl. MwSt)')),
                ('vat_rate', models.FloatField(choices=[(0.0, '0.0% (Mehrwertsteuerfrei)'), (2.5, '2.5% (Bis 2023: Reduzierter Satz)'), (2.6, '2.6% (Ab 2024: Reduzierter Satz)'), (3.7, '3.7% (Bis 2023: Sondersatz für Beherbergung)'), (3.8, '3.8% (Ab 2024: Sondersatz für Beherbergung)'), (7.7, '7.7% (Bis 2023: Normalsatz)'), (8.1, '8.1% (Ab 2024: Normalsatz)')], default=7.7, verbose_name='MwSt-Satz')),
                ('linked_fee', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.fee', verbose_name='Verknüpfte Kosten')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.order')),
            ],
            options={
                'verbose_name': 'Bestellungskosten',
                'verbose_name_plural': 'Bestellungskosten',
            },
        ),
        migrations.AddField(
            model_name='order',
            name='fees',
            field=models.ManyToManyField(through='kmuhelper.OrderFee', to='kmuhelper.fee'),
        ),
        migrations.AddField(
            model_name='order',
            name='payment_receiver',
            field=models.ForeignKey(default=kmuhelper.modules.main.models.default_payment_recipient, on_delete=django.db.models.deletion.PROTECT, to='kmuhelper.paymentreceiver', verbose_name='Zahlungsempfänger'),
        ),
        migrations.AddField(
            model_name='order',
            name='products',
            field=models.ManyToManyField(through='kmuhelper.OrderItem', to='kmuhelper.product'),
        ),
        migrations.CreateModel(
            name='Note',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Name')),
                ('description', models.TextField(blank=True, default='', verbose_name='Beschrieb')),
                ('done', models.BooleanField(default=False, verbose_name='Erledigt?')),
                ('priority', models.IntegerField(blank=True, default=0, verbose_name='Priorität')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Erstellt am')),
                ('linked_customer', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='linked_note', to='kmuhelper.customer')),
                ('linked_order', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='linked_note', to='kmuhelper.order')),
                ('linked_product', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='linked_note', to='kmuhelper.product')),
                ('linked_supply', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='linked_note', to='kmuhelper.supply')),
            ],
            options={
                'verbose_name': 'Notiz',
                'verbose_name_plural': 'Notizen',
            },
        ),
        migrations.CreateModel(
            name='EMailAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attachment', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='emails', to='kmuhelper.attachment')),
                ('email', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kmuhelper.email')),
            ],
            options={
                'verbose_name': 'E-Mail-Anhang',
                'verbose_name_plural': 'E-Mail-Anhänge',
            },
        ),
        migrations.AddField(
            model_name='email',
            name='attachments',
            field=models.ManyToManyField(through='kmuhelper.EMailAttachment', to='kmuhelper.attachment'),
        ),
        migrations.AddField(
            model_name='customer',
            name='email_link_registered',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='kmuhelper.email'),
        ),
        migrations.CreateModel(
            name='ApiKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='Key')),
                ('name', models.CharField(blank=True, default='', max_length=100, verbose_name='Name')),
                ('read', models.BooleanField(default=True, verbose_name='Read permission?')),
                ('write', models.BooleanField(default=False, verbose_name='Write permission?')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Api key',
                'verbose_name_plural': 'Api keys',
            },
        ),
        migrations.CreateModel(
            name='App_Arrival',
            fields=[
            ],
            options={
                'verbose_name': 'Lieferung',
                'verbose_name_plural': 'Lieferungen',
                'proxy': True,
                'default_permissions': ('add', 'change', 'view'),
                'indexes': [],
                'constraints': [],
            },
            bases=('kmuhelper.supply',),
        ),
        migrations.CreateModel(
            name='App_IncomingPayments',
            fields=[
            ],
            options={
                'verbose_name': 'Bestellung',
                'verbose_name_plural': 'Bestellungen',
                'proxy': True,
                'default_permissions': ('add', 'change', 'view'),
                'indexes': [],
                'constraints': [],
            },
            bases=('kmuhelper.order',),
        ),
        migrations.CreateModel(
            name='App_Shipping',
            fields=[
            ],
            options={
                'verbose_name': 'Bestellung',
                'verbose_name_plural': 'Bestellungen',
                'proxy': True,
                'default_permissions': ('add', 'change', 'view'),
                'indexes': [],
                'constraints': [],
            },
            bases=('kmuhelper.order',),
        ),
        migrations.CreateModel(
            name='App_Stock',
            fields=[
            ],
            options={
                'verbose_name': 'Produkt',
                'verbose_name_plural': 'Produkte',
                'proxy': True,
                'default_permissions': ('add', 'change', 'view'),
                'indexes': [],
                'constraints': [],
            },
            bases=('kmuhelper.product',),
        ),
        migrations.CreateModel(
            name='App_ToDo',
            fields=[
            ],
            options={
                'verbose_name': 'Notiz',
                'verbose_name_plural': 'Notizen',
                'proxy': True,
                'default_permissions': ('add', 'change', 'view'),
                'indexes': [],
                'constraints': [],
            },
            bases=('kmuhelper.note',),
        ),
    ]
