<a id="mypy-boto3-kinesisanalyticsv2"></a>

# mypy-boto3-kinesisanalyticsv2

[![PyPI - mypy-boto3-kinesisanalyticsv2](https://img.shields.io/pypi/v/mypy-boto3-kinesisanalyticsv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-kinesisanalyticsv2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-kinesisanalyticsv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-kinesisanalyticsv2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-kinesisanalyticsv2?color=blue)](https://pypistats.org/packages/mypy-boto3-kinesisanalyticsv2)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.KinesisAnalyticsV2 1.18.24](https://boto3.amazonaws.com/v1/documentation/api/1.18.24/reference/services/kinesisanalyticsv2.html#KinesisAnalyticsV2)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-kinesisanalyticsv2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesisanalyticsv2/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-kinesisanalyticsv2](#mypy-boto3-kinesisanalyticsv2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `KinesisAnalyticsV2` service.

```bash
python -m pip install boto3-stubs[kinesisanalyticsv2]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[kinesisanalyticsv2]` in your environment:
  `python -m pip install 'boto3-stubs[kinesisanalyticsv2]'`

Both type checking and auto-complete should work for `KinesisAnalyticsV2`
service. No explicit type annotations required, write your `boto3` code as
usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[kinesisanalyticsv2]` in your environment:
  `python -m pip install 'boto3-stubs[kinesisanalyticsv2]'`

Both type checking and auto-complete should work for `KinesisAnalyticsV2`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[kinesisanalyticsv2]` in your environment:
  `python -m pip install 'boto3-stubs[kinesisanalyticsv2]'`
- Run `mypy` as usual

Type checking should work for `KinesisAnalyticsV2` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[kinesisanalyticsv2]` in your environment:
  `python -m pip install 'boto3-stubs[kinesisanalyticsv2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `KinesisAnalyticsV2` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`KinesisAnalyticsV2Client` provides annotations for
`boto3.client("kinesisanalyticsv2")`.

```python
import boto3

from mypy_boto3_kinesisanalyticsv2 import KinesisAnalyticsV2Client

client: KinesisAnalyticsV2Client = boto3.client("kinesisanalyticsv2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: KinesisAnalyticsV2Client = session.client("kinesisanalyticsv2")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_kinesisanalyticsv2.paginator` module contains type annotations for
all paginators.

```python
from mypy_boto3_kinesisanalyticsv2 import KinesisAnalyticsV2Client
from mypy_boto3_kinesisanalyticsv2.paginator import (
    ListApplicationSnapshotsPaginator,
    ListApplicationsPaginator,
)

client: KinesisAnalyticsV2Client = boto3.client("kinesisanalyticsv2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_application_snapshots_paginator: ListApplicationSnapshotsPaginator = client.get_paginator("list_application_snapshots")
list_applications_paginator: ListApplicationsPaginator = client.get_paginator("list_applications")
```

<a id="literals"></a>

### Literals

`mypy_boto3_kinesisanalyticsv2.literals` module contains literals extracted
from shapes that can be used in user code for type checking.

```python
from mypy_boto3_kinesisanalyticsv2.literals import (
    ApplicationModeType,
    ApplicationRestoreTypeType,
    ApplicationStatusType,
    ArtifactTypeType,
    CodeContentTypeType,
    ConfigurationTypeType,
    InputStartingPositionType,
    ListApplicationSnapshotsPaginatorName,
    ListApplicationsPaginatorName,
    LogLevelType,
    MetricsLevelType,
    RecordFormatTypeType,
    RuntimeEnvironmentType,
    SnapshotStatusType,
    UrlTypeType,
)

def check_value(value: ApplicationModeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_kinesisanalyticsv2.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_kinesisanalyticsv2.type_defs import (
    AddApplicationCloudWatchLoggingOptionRequestRequestTypeDef,
    AddApplicationCloudWatchLoggingOptionResponseTypeDef,
    AddApplicationInputProcessingConfigurationRequestRequestTypeDef,
    AddApplicationInputProcessingConfigurationResponseTypeDef,
    AddApplicationInputRequestRequestTypeDef,
    AddApplicationInputResponseTypeDef,
    AddApplicationOutputRequestRequestTypeDef,
    AddApplicationOutputResponseTypeDef,
    AddApplicationReferenceDataSourceRequestRequestTypeDef,
    AddApplicationReferenceDataSourceResponseTypeDef,
    AddApplicationVpcConfigurationRequestRequestTypeDef,
    AddApplicationVpcConfigurationResponseTypeDef,
    ApplicationCodeConfigurationDescriptionTypeDef,
    ApplicationCodeConfigurationTypeDef,
    ApplicationCodeConfigurationUpdateTypeDef,
    ApplicationConfigurationDescriptionTypeDef,
    ApplicationConfigurationTypeDef,
    ApplicationConfigurationUpdateTypeDef,
    ApplicationDetailTypeDef,
    ApplicationMaintenanceConfigurationDescriptionTypeDef,
    ApplicationMaintenanceConfigurationUpdateTypeDef,
    ApplicationRestoreConfigurationTypeDef,
    ApplicationSnapshotConfigurationDescriptionTypeDef,
    ApplicationSnapshotConfigurationTypeDef,
    ApplicationSnapshotConfigurationUpdateTypeDef,
    ApplicationSummaryTypeDef,
    ApplicationVersionSummaryTypeDef,
    CSVMappingParametersTypeDef,
    CatalogConfigurationDescriptionTypeDef,
    CatalogConfigurationTypeDef,
    CatalogConfigurationUpdateTypeDef,
    CheckpointConfigurationDescriptionTypeDef,
    CheckpointConfigurationTypeDef,
    CheckpointConfigurationUpdateTypeDef,
    CloudWatchLoggingOptionDescriptionTypeDef,
    CloudWatchLoggingOptionTypeDef,
    CloudWatchLoggingOptionUpdateTypeDef,
    CodeContentDescriptionTypeDef,
    CodeContentTypeDef,
    CodeContentUpdateTypeDef,
    CreateApplicationPresignedUrlRequestRequestTypeDef,
    CreateApplicationPresignedUrlResponseTypeDef,
    CreateApplicationRequestRequestTypeDef,
    CreateApplicationResponseTypeDef,
    CreateApplicationSnapshotRequestRequestTypeDef,
    CustomArtifactConfigurationDescriptionTypeDef,
    CustomArtifactConfigurationTypeDef,
    DeleteApplicationCloudWatchLoggingOptionRequestRequestTypeDef,
    DeleteApplicationCloudWatchLoggingOptionResponseTypeDef,
    DeleteApplicationInputProcessingConfigurationRequestRequestTypeDef,
    DeleteApplicationInputProcessingConfigurationResponseTypeDef,
    DeleteApplicationOutputRequestRequestTypeDef,
    DeleteApplicationOutputResponseTypeDef,
    DeleteApplicationReferenceDataSourceRequestRequestTypeDef,
    DeleteApplicationReferenceDataSourceResponseTypeDef,
    DeleteApplicationRequestRequestTypeDef,
    DeleteApplicationSnapshotRequestRequestTypeDef,
    DeleteApplicationVpcConfigurationRequestRequestTypeDef,
    DeleteApplicationVpcConfigurationResponseTypeDef,
    DeployAsApplicationConfigurationDescriptionTypeDef,
    DeployAsApplicationConfigurationTypeDef,
    DeployAsApplicationConfigurationUpdateTypeDef,
    DescribeApplicationRequestRequestTypeDef,
    DescribeApplicationResponseTypeDef,
    DescribeApplicationSnapshotRequestRequestTypeDef,
    DescribeApplicationSnapshotResponseTypeDef,
    DescribeApplicationVersionRequestRequestTypeDef,
    DescribeApplicationVersionResponseTypeDef,
    DestinationSchemaTypeDef,
    DiscoverInputSchemaRequestRequestTypeDef,
    DiscoverInputSchemaResponseTypeDef,
    EnvironmentPropertiesTypeDef,
    EnvironmentPropertyDescriptionsTypeDef,
    EnvironmentPropertyUpdatesTypeDef,
    FlinkApplicationConfigurationDescriptionTypeDef,
    FlinkApplicationConfigurationTypeDef,
    FlinkApplicationConfigurationUpdateTypeDef,
    FlinkRunConfigurationTypeDef,
    GlueDataCatalogConfigurationDescriptionTypeDef,
    GlueDataCatalogConfigurationTypeDef,
    GlueDataCatalogConfigurationUpdateTypeDef,
    InputDescriptionTypeDef,
    InputLambdaProcessorDescriptionTypeDef,
    InputLambdaProcessorTypeDef,
    InputLambdaProcessorUpdateTypeDef,
    InputParallelismTypeDef,
    InputParallelismUpdateTypeDef,
    InputProcessingConfigurationDescriptionTypeDef,
    InputProcessingConfigurationTypeDef,
    InputProcessingConfigurationUpdateTypeDef,
    InputSchemaUpdateTypeDef,
    InputStartingPositionConfigurationTypeDef,
    InputTypeDef,
    InputUpdateTypeDef,
    JSONMappingParametersTypeDef,
    KinesisFirehoseInputDescriptionTypeDef,
    KinesisFirehoseInputTypeDef,
    KinesisFirehoseInputUpdateTypeDef,
    KinesisFirehoseOutputDescriptionTypeDef,
    KinesisFirehoseOutputTypeDef,
    KinesisFirehoseOutputUpdateTypeDef,
    KinesisStreamsInputDescriptionTypeDef,
    KinesisStreamsInputTypeDef,
    KinesisStreamsInputUpdateTypeDef,
    KinesisStreamsOutputDescriptionTypeDef,
    KinesisStreamsOutputTypeDef,
    KinesisStreamsOutputUpdateTypeDef,
    LambdaOutputDescriptionTypeDef,
    LambdaOutputTypeDef,
    LambdaOutputUpdateTypeDef,
    ListApplicationSnapshotsRequestRequestTypeDef,
    ListApplicationSnapshotsResponseTypeDef,
    ListApplicationVersionsRequestRequestTypeDef,
    ListApplicationVersionsResponseTypeDef,
    ListApplicationsRequestRequestTypeDef,
    ListApplicationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MappingParametersTypeDef,
    MavenReferenceTypeDef,
    MonitoringConfigurationDescriptionTypeDef,
    MonitoringConfigurationTypeDef,
    MonitoringConfigurationUpdateTypeDef,
    OutputDescriptionTypeDef,
    OutputTypeDef,
    OutputUpdateTypeDef,
    PaginatorConfigTypeDef,
    ParallelismConfigurationDescriptionTypeDef,
    ParallelismConfigurationTypeDef,
    ParallelismConfigurationUpdateTypeDef,
    PropertyGroupTypeDef,
    RecordColumnTypeDef,
    RecordFormatTypeDef,
    ReferenceDataSourceDescriptionTypeDef,
    ReferenceDataSourceTypeDef,
    ReferenceDataSourceUpdateTypeDef,
    ResponseMetadataTypeDef,
    RollbackApplicationRequestRequestTypeDef,
    RollbackApplicationResponseTypeDef,
    RunConfigurationDescriptionTypeDef,
    RunConfigurationTypeDef,
    RunConfigurationUpdateTypeDef,
    S3ApplicationCodeLocationDescriptionTypeDef,
    S3ConfigurationTypeDef,
    S3ContentBaseLocationDescriptionTypeDef,
    S3ContentBaseLocationTypeDef,
    S3ContentBaseLocationUpdateTypeDef,
    S3ContentLocationTypeDef,
    S3ContentLocationUpdateTypeDef,
    S3ReferenceDataSourceDescriptionTypeDef,
    S3ReferenceDataSourceTypeDef,
    S3ReferenceDataSourceUpdateTypeDef,
    SnapshotDetailsTypeDef,
    SourceSchemaTypeDef,
    SqlApplicationConfigurationDescriptionTypeDef,
    SqlApplicationConfigurationTypeDef,
    SqlApplicationConfigurationUpdateTypeDef,
    SqlRunConfigurationTypeDef,
    StartApplicationRequestRequestTypeDef,
    StopApplicationRequestRequestTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateApplicationMaintenanceConfigurationRequestRequestTypeDef,
    UpdateApplicationMaintenanceConfigurationResponseTypeDef,
    UpdateApplicationRequestRequestTypeDef,
    UpdateApplicationResponseTypeDef,
    VpcConfigurationDescriptionTypeDef,
    VpcConfigurationTypeDef,
    VpcConfigurationUpdateTypeDef,
    ZeppelinApplicationConfigurationDescriptionTypeDef,
    ZeppelinApplicationConfigurationTypeDef,
    ZeppelinApplicationConfigurationUpdateTypeDef,
    ZeppelinMonitoringConfigurationDescriptionTypeDef,
    ZeppelinMonitoringConfigurationTypeDef,
    ZeppelinMonitoringConfigurationUpdateTypeDef,
)

def get_structure() -> AddApplicationCloudWatchLoggingOptionRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-kinesisanalyticsv2` version is the same as related `boto3` version
and follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-kinesisanalyticsv2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesisanalyticsv2/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
