"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A bounce template.
 */
class BounceTemplate {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_BounceTemplateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BounceTemplate);
            }
            throw error;
        }
    }
}
exports.BounceTemplate = BounceTemplate;
_a = JSII_RTTI_SYMBOL_1;
BounceTemplate[_a] = { fqn: "@aws-cdk/aws-ses-actions.BounceTemplate", version: "1.163.1" };
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * Rejects the received email by returning a bounce response to the sender and,
 * optionally, publishes a notification to Amazon SNS.
 */
class Bounce {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_BounceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Bounce);
            }
            throw error;
        }
    }
    bind(_rule) {
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: this.props.topic?.topicArn,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
_b = JSII_RTTI_SYMBOL_1;
Bounce[_b] = { fqn: "@aws-cdk/aws-ses-actions.Bounce", version: "1.163.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYm91bmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYm91bmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQTJCQTs7R0FFRztBQUNILE1BQWEsY0FBYztJQStCekIsWUFBNEIsS0FBMEI7UUFBMUIsVUFBSyxHQUFMLEtBQUssQ0FBcUI7Ozs7OzsrQ0EvQjNDLGNBQWM7Ozs7S0FnQ3hCOztBQWhDSCx3Q0FpQ0M7OztBQWhDd0IscUNBQXNCLEdBQUcsSUFBSSxjQUFjLENBQUM7SUFDakUsT0FBTyxFQUFFLHdCQUF3QjtJQUNqQyxhQUFhLEVBQUUsS0FBSztJQUNwQixVQUFVLEVBQUUsT0FBTztDQUNwQixDQUFDLENBQUM7QUFFb0IsZ0NBQWlCLEdBQUcsSUFBSSxjQUFjLENBQUM7SUFDNUQsT0FBTyxFQUFFLG1CQUFtQjtJQUM1QixhQUFhLEVBQUUsS0FBSztJQUNwQixVQUFVLEVBQUUsT0FBTztDQUNwQixDQUFDLENBQUM7QUFFb0IsMkJBQVksR0FBRyxJQUFJLGNBQWMsQ0FBQztJQUN2RCxPQUFPLEVBQUUsY0FBYztJQUN2QixhQUFhLEVBQUUsS0FBSztJQUNwQixVQUFVLEVBQUUsT0FBTztDQUNwQixDQUFDLENBQUM7QUFFb0IsdUNBQXdCLEdBQUcsSUFBSSxjQUFjLENBQUM7SUFDbkUsT0FBTyxFQUFFLDBCQUEwQjtJQUNuQyxhQUFhLEVBQUUsS0FBSztJQUNwQixVQUFVLEVBQUUsT0FBTztDQUNwQixDQUFDLENBQUM7QUFFb0IsZ0NBQWlCLEdBQUcsSUFBSSxjQUFjLENBQUM7SUFDNUQsT0FBTyxFQUFFLG1CQUFtQjtJQUM1QixhQUFhLEVBQUUsS0FBSztJQUNwQixVQUFVLEVBQUUsT0FBTztDQUNwQixDQUFDLENBQUM7QUE2Qkw7OztHQUdHO0FBQ0gsTUFBYSxNQUFNO0lBQ2pCLFlBQTZCLEtBQWtCO1FBQWxCLFVBQUssR0FBTCxLQUFLLENBQWE7Ozs7OzsrQ0FEcEMsTUFBTTs7OztLQUVoQjtJQUVNLElBQUksQ0FBQyxLQUF1QjtRQUNqQyxPQUFPO1lBQ0wsWUFBWSxFQUFFO2dCQUNaLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU07Z0JBQ3pCLGFBQWEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsYUFBYTtnQkFDdEQsT0FBTyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxPQUFPO2dCQUMxQyxRQUFRLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsUUFBUTtnQkFDcEMsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxVQUFVO2FBQ2pEO1NBQ0YsQ0FBQztLQUNIOztBQWRILHdCQWVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2VzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zZXMnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIEJvdW5jZVRlbXBsYXRlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEJvdW5jZVRlbXBsYXRlUHJvcHMge1xuICAvKipcbiAgICogSHVtYW4tcmVhZGFibGUgdGV4dCB0byBpbmNsdWRlIGluIHRoZSBib3VuY2UgbWVzc2FnZS5cbiAgICovXG4gIHJlYWRvbmx5IG1lc3NhZ2U6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIFNNVFAgcmVwbHkgY29kZSwgYXMgZGVmaW5lZCBieSBSRkMgNTMyMS5cbiAgICpcbiAgICogQHNlZSBodHRwczovL3Rvb2xzLmlldGYub3JnL2h0bWwvcmZjNTMyMVxuICAgKi9cbiAgcmVhZG9ubHkgc210cFJlcGx5Q29kZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgU01UUCBlbmhhbmNlZCBzdGF0dXMgY29kZSwgYXMgZGVmaW5lZCBieSBSRkMgMzQ2My5cbiAgICpcbiAgICogQHNlZSBodHRwczovL3Rvb2xzLmlldGYub3JnL2h0bWwvcmZjMzQ2M1xuICAgKi9cbiAgcmVhZG9ubHkgc3RhdHVzQ29kZT86IHN0cmluZztcbn1cblxuLyoqXG4gKiBBIGJvdW5jZSB0ZW1wbGF0ZS5cbiAqL1xuZXhwb3J0IGNsYXNzIEJvdW5jZVRlbXBsYXRlIHtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBNQUlMQk9YX0RPRVNfTk9UX0VYSVNUID0gbmV3IEJvdW5jZVRlbXBsYXRlKHtcbiAgICBtZXNzYWdlOiAnTWFpbGJveCBkb2VzIG5vdCBleGlzdCcsXG4gICAgc210cFJlcGx5Q29kZTogJzU1MCcsXG4gICAgc3RhdHVzQ29kZTogJzUuMS4xJyxcbiAgfSk7XG5cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBNRVNTQUdFX1RPT19MQVJHRSA9IG5ldyBCb3VuY2VUZW1wbGF0ZSh7XG4gICAgbWVzc2FnZTogJ01lc3NhZ2UgdG9vIGxhcmdlJyxcbiAgICBzbXRwUmVwbHlDb2RlOiAnNTUyJyxcbiAgICBzdGF0dXNDb2RlOiAnNS4zLjQnLFxuICB9KTtcblxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE1BSUxCT1hfRlVMTCA9IG5ldyBCb3VuY2VUZW1wbGF0ZSh7XG4gICAgbWVzc2FnZTogJ01haWxib3ggZnVsbCcsXG4gICAgc210cFJlcGx5Q29kZTogJzU1MicsXG4gICAgc3RhdHVzQ29kZTogJzUuMi4yJyxcbiAgfSk7XG5cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBNRVNTQUdFX0NPTlRFTlRfUkVKRUNURUQgPSBuZXcgQm91bmNlVGVtcGxhdGUoe1xuICAgIG1lc3NhZ2U6ICdNZXNzYWdlIGNvbnRlbnQgcmVqZWN0ZWQnLFxuICAgIHNtdHBSZXBseUNvZGU6ICc1MDAnLFxuICAgIHN0YXR1c0NvZGU6ICc1LjYuMScsXG4gIH0pO1xuXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVEVNUE9SQVJZX0ZBSUxVUkUgPSBuZXcgQm91bmNlVGVtcGxhdGUoe1xuICAgIG1lc3NhZ2U6ICdUZW1wb3JhcnkgZmFpbHVyZScsXG4gICAgc210cFJlcGx5Q29kZTogJzQ1MCcsXG4gICAgc3RhdHVzQ29kZTogJzQuMC4wJyxcbiAgfSk7XG5cbiAgY29uc3RydWN0b3IocHVibGljIHJlYWRvbmx5IHByb3BzOiBCb3VuY2VUZW1wbGF0ZVByb3BzKSB7XG4gIH1cbn1cblxuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBmb3IgYSBib3VuY2UgYWN0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEJvdW5jZVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSB0ZW1wbGF0ZSBjb250YWluaW5nIHRoZSBtZXNzYWdlLCByZXBseSBjb2RlIGFuZCBzdGF0dXMgY29kZS5cbiAgICovXG4gIHJlYWRvbmx5IHRlbXBsYXRlOiBCb3VuY2VUZW1wbGF0ZTtcblxuICAvKipcbiAgICogVGhlIGVtYWlsIGFkZHJlc3Mgb2YgdGhlIHNlbmRlciBvZiB0aGUgYm91bmNlZCBlbWFpbC4gVGhpcyBpcyB0aGUgYWRkcmVzc1xuICAgKiBmcm9tIHdoaWNoIHRoZSBib3VuY2UgbWVzc2FnZSB3aWxsIGJlIHNlbnQuXG4gICAqL1xuICByZWFkb25seSBzZW5kZXI6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIFNOUyB0b3BpYyB0byBub3RpZnkgd2hlbiB0aGUgYm91bmNlIGFjdGlvbiBpcyB0YWtlbi5cbiAgICpcbiAgICogQGRlZmF1bHQgbm8gbm90aWZpY2F0aW9uXG4gICAqL1xuICByZWFkb25seSB0b3BpYz86IHNucy5JVG9waWM7XG59XG5cbi8qKlxuICogUmVqZWN0cyB0aGUgcmVjZWl2ZWQgZW1haWwgYnkgcmV0dXJuaW5nIGEgYm91bmNlIHJlc3BvbnNlIHRvIHRoZSBzZW5kZXIgYW5kLFxuICogb3B0aW9uYWxseSwgcHVibGlzaGVzIGEgbm90aWZpY2F0aW9uIHRvIEFtYXpvbiBTTlMuXG4gKi9cbmV4cG9ydCBjbGFzcyBCb3VuY2UgaW1wbGVtZW50cyBzZXMuSVJlY2VpcHRSdWxlQWN0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogQm91bmNlUHJvcHMpIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9ydWxlOiBzZXMuSVJlY2VpcHRSdWxlKTogc2VzLlJlY2VpcHRSdWxlQWN0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgYm91bmNlQWN0aW9uOiB7XG4gICAgICAgIHNlbmRlcjogdGhpcy5wcm9wcy5zZW5kZXIsXG4gICAgICAgIHNtdHBSZXBseUNvZGU6IHRoaXMucHJvcHMudGVtcGxhdGUucHJvcHMuc210cFJlcGx5Q29kZSxcbiAgICAgICAgbWVzc2FnZTogdGhpcy5wcm9wcy50ZW1wbGF0ZS5wcm9wcy5tZXNzYWdlLFxuICAgICAgICB0b3BpY0FybjogdGhpcy5wcm9wcy50b3BpYz8udG9waWNBcm4sXG4gICAgICAgIHN0YXR1c0NvZGU6IHRoaXMucHJvcHMudGVtcGxhdGUucHJvcHMuc3RhdHVzQ29kZSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19