"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lambda = exports.LambdaInvocationType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * The type of invocation to use for a Lambda Action.
 */
var LambdaInvocationType;
(function (LambdaInvocationType) {
    /**
     * The function will be invoked asynchronously.
     */
    LambdaInvocationType["EVENT"] = "Event";
    /**
     * The function will be invoked sychronously. Use RequestResponse only when
     * you want to make a mail flow decision, such as whether to stop the receipt
     * rule or the receipt rule set.
     */
    LambdaInvocationType["REQUEST_RESPONSE"] = "RequestResponse";
})(LambdaInvocationType = exports.LambdaInvocationType || (exports.LambdaInvocationType = {}));
/**
 * Calls an AWS Lambda function, and optionally, publishes a notification to
 * Amazon SNS.
 */
class Lambda {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_LambdaProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Lambda);
            }
            throw error;
        }
    }
    bind(rule) {
        // Allow SES to invoke Lambda function
        // See https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html#receiving-email-permissions-lambda
        const permissionId = 'AllowSes';
        if (!this.props.function.permissionsNode.tryFindChild(permissionId)) {
            this.props.function.addPermission(permissionId, {
                action: 'lambda:InvokeFunction',
                principal: new iam.ServicePrincipal('ses.amazonaws.com'),
                sourceAccount: cdk.Aws.ACCOUNT_ID,
            });
        }
        // Ensure permission is deployed before rule
        const permission = this.props.function.permissionsNode.tryFindChild(permissionId);
        if (permission) { // The Lambda could be imported
            rule.node.addDependency(permission);
        }
        else {
            // eslint-disable-next-line max-len
            cdk.Annotations.of(rule).addWarning('This rule is using a Lambda action with an imported function. Ensure permission is given to SES to invoke that function.');
        }
        return {
            lambdaAction: {
                functionArn: this.props.function.functionArn,
                invocationType: this.props.invocationType,
                topicArn: this.props.topic?.topicArn,
            },
        };
    }
}
exports.Lambda = Lambda;
_a = JSII_RTTI_SYMBOL_1;
Lambda[_a] = { fqn: "@aws-cdk/aws-ses-actions.Lambda", version: "1.163.1" };
//# sourceMappingURL=data:application/json;base64,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