# mypy-boto3-ram

[![PyPI - mypy-boto3-ram](https://img.shields.io/pypi/v/mypy-boto3-ram.svg?color=blue)](https://pypi.org/project/mypy-boto3-ram)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ram.svg?color=blue)](https://pypi.org/project/mypy-boto3-ram)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.RAM 1.14.1](https://boto3.amazonaws.com/v1/documentation/api/1.14.1/reference/services/ram.html#RAM) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `RAM` service.

```bash
python -m pip install boto3-stubs[ram]
```

## How to use

### Client annotations

`RAMClient` provides annotations for `boto3.client("ram")`.

```python
import boto3

from mypy_boto3_ram import RAMClient
from mypy_boto3_ram.paginator import (
    GetResourcePoliciesPaginator,
    GetResourceShareAssociationsPaginator,
    GetResourceShareInvitationsPaginator,
    GetResourceSharesPaginator,
    ListPrincipalsPaginator,
    ListResourcesPaginator,
)
from mypy_boto3_ram.type_defs import PrincipalTypeDef, ...

client: RAMClient = boto3.client("ram")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RAMClient = session.client("ram")
```

### Paginators annotations

`mypy_boto3_ram.paginator` module contains type annotations for all paginators.

```python

client: RAMClient = boto3.client("ram")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_resource_policies_paginator: GetResourcePoliciesPaginator = client.get_paginator("get_resource_policies")
get_resource_share_associations_paginator: GetResourceShareAssociationsPaginator = client.get_paginator("get_resource_share_associations")
get_resource_share_invitations_paginator: GetResourceShareInvitationsPaginator = client.get_paginator("get_resource_share_invitations")
get_resource_shares_paginator: GetResourceSharesPaginator = client.get_paginator("get_resource_shares")
list_principals_paginator: ListPrincipalsPaginator = client.get_paginator("list_principals")
list_resources_paginator: ListResourcesPaginator = client.get_paginator("list_resources")
```







### Typed dictionations

`mypy_boto3_ram.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> PrincipalTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_ram` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("ram")

session_client = boto3.Session().client("ram")
```
