from ji_auth.login import JaccountCLILogin


async def get_joj_sid():
    async with JaccountCLILogin("https://joj.sjtu.edu.cn/login/jaccount") as cli:
        await cli.login()
        cookies = cli.get_cookies()
        return cookies["sid"].value


if __name__ == "__main__":
    import asyncio

    res = asyncio.get_event_loop().run_until_complete(get_joj_sid())
    print(res)
