| Element | Description |
| --- | --- |
| [`<a>`](/en-US/docs/Web/HTML/Element/a "The HTML Anchor Element (<a>) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL.") | The _HTML `Anchor` Element_ (**`<a>`**) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL. |
| [`<abbr>`](/en-US/docs/Web/HTML/Element/abbr "The HTML <abbr> element (or HTML Abbreviation Element) represents an abbreviation and optionally provides a full description for it. If present, the title attribute must contain this full description and nothing else.") | The **HTML `<abbr>` element** (or _HTML Abbreviation Element_) represents an abbreviation and optionally provides a full description for it. If present, the `title` attribute must contain this full description and nothing else. |
| [`<b>`](/en-US/docs/Web/HTML/Element/b "The HTML <b> Element represents a span of text stylistically different from normal text, without conveying any special importance or relevance. It is typically used for keywords in a summary, product names in a review, or other spans of text whose typical presentation would be boldfaced. Another example of its use is to mark the lead sentence of each paragraph of an article.") | The **HTML `<b>` Element** represents a span of text stylistically different from normal text, without conveying any special importance or relevance. It is typically used for keywords in a summary, product names in a review, or other spans of text whose typical presentation would be boldfaced. Another example of its use is to mark the lead sentence of each paragraph of an article. |
| [`<bdi>`](/en-US/docs/Web/HTML/Element/bdi "The HTML <bdi> Element (or Bi-Directional Isolation Element) isolates a span of text that might be formatted in a different direction from other text outside it.") | The _HTML `<bdi>` Element_ (or Bi-Directional Isolation Element) isolates a span of text that might be formatted in a different direction from other text outside it. |
| [`<bdo>`](/en-US/docs/Web/HTML/Element/bdo "The HTML <bdo> Element (or HTML bidirectional override element) is used to override the current directionality of text. It causes the directionality of the characters to be ignored in favor of the specified directionality.") | The **HTML `<bdo>` Element** (or _HTML bidirectional override element_) is used to override the current directionality of text. It causes the directionality of the characters to be ignored in favor of the specified directionality. |
| [`<br>`](/en-US/docs/Web/HTML/Element/br "The HTML element line break <br> produces a line break in text (carriage-return). It is useful for writing a poem or an address, where the division of lines is significant.") | The HTML element _l_ _ine break_ `<br>` produces a line break in text (carriage-return). It is useful for writing a poem or an address, where the division of lines is significant. |
| [`<cite>`](/en-US/docs/Web/HTML/Element/cite "The HTML Citation Element (<cite>) represents a reference to a creative work. It must include the title of a work or a URL reference, which may be in an abbreviated form according to the conventions used for the addition of citation metadata.") | The _HTML Citation Element_ (**<cite>**) represents a reference to a creative work. It must include the title of a work or a URL reference, which may be in an abbreviated form according to the conventions used for the addition of citation metadata. |
| [`<code>`](/en-US/docs/Web/HTML/Element/code "The HTML Code Element (<code>) represents a fragment of computer code. By default, it is displayed in the browser's default monospace font.") | The _HTML Code Element_ (**<code>**) represents a fragment of computer code. By default, it is displayed in the browser's default monospace font. |
| [`<data>`](/en-US/docs/Web/HTML/Element/data "The HTML <data> Element links a given content with a machine-readable translation. If the content is time- or date-related, the <time> must be used.") | The **HTML `<data>` Element** links a given content with a machine-readable translation. If the content is time- or date-related, the [`<time>`](/en-US/docs/Web/HTML/Element/time "The HTML <time> element represents either a time on a 24-hour clock or a precise date in the Gregorian calendar (with optional time and timezone information).") must be used. |
| [`<dfn>`](/en-US/docs/Web/HTML/Element/dfn "The HTML Definition Element (<dfn>) represents the defining instance of a term.") | The _HTML Definition Element_ (**<dfn>**) represents the defining instance of a term. |
| [`<em>`](/en-US/docs/Web/HTML/Element/em "The HTML element emphasis  <em> marks text that has stress emphasis. The <em> element can be nested, with each level of nesting indicating a greater degree of emphasis.") | The HTML element _emphasis_ **<em>** marks text that has stress emphasis. The `<em>` element can be nested, with each level of nesting indicating a greater degree of emphasis. |
| [`<i>`](/en-US/docs/Web/HTML/Element/i "The HTML <i> Element represents a range of text that is set off from the normal text for some reason, for example, technical terms, foreign language phrases, or fictional character thoughts. It is typically displayed in italic type.") | The **HTML `<i>` Element** represents a range of text that is set off from the normal text for some reason, for example, technical terms, foreign language phrases, or fictional character thoughts. It is typically displayed in italic type. |
| [`<kbd>`](/en-US/docs/Web/HTML/Element/kbd "The HTML Keyboard Input Element (<kbd>) represents user input and produces an inline element displayed in the browser's default monospace font.") | The _HTML Keyboard Input Element_ (**<kbd>**) represents user input and produces an inline element displayed in the browser's default monospace font. |
| [`<mark>`](/en-US/docs/Web/HTML/Element/mark "The HTML Mark Element (<mark>) represents highlighted text, i.e., a run of text marked for reference purpose, due to its relevance in a particular context. For example it can be used in a page showing search results to highlight every instance of the searched-for word.") | The _HTML Mark Element_ (<mark>) represents highlighted text, i.e., a run of text marked for reference purpose, due to its _relevance_ in a particular context. For example it can be used in a page showing search results to highlight every instance of the searched-for word. |
| [`<q>`](/en-US/docs/Web/HTML/Element/q "The HTML Quote Element (<q>) indicates that the enclosed text is a short inline quotation. This element is intended for short quotations that don't require paragraph breaks; for long quotations use the <blockquote> element.") | The _HTML Quote Element_ (**<q>**) indicates that the enclosed text is a short inline quotation. This element is intended for short quotations that don't require paragraph breaks; for long quotations use the [`<blockquote>`](/en-US/docs/Web/HTML/Element/blockquote "The HTML <blockquote> Element (or HTML Block Quotation Element) indicates that the enclosed text is an extended quotation. Usually, this is rendered visually by indentation (see Notes for how to change it). A URL for the source of the quotation may be given using the cite attribute, while a text representation of the source can be given using the <cite> element.") element. |
| [`<rp>`](/en-US/docs/Web/HTML/Element/rp "The HTML <rp> element is used to provide fall-back parenthesis for browsers non-supporting ruby annotations. Ruby annotations are for showing pronunciation of East Asian characters, like using Japanese furigana or Taiwainese bopomofo characters. The <rp> element is used in the case of lack of <ruby> element support its content has what should be displayed in order to indicate the presence of a ruby annotation, usually parentheses.") | The **HTML `<rp>` element** is used to provide fall-back parenthesis for browsers non-supporting ruby annotations. Ruby annotations are for showing pronunciation of East Asian characters, like using Japanese furigana or Taiwainese bopomofo characters. The `<rp>` element is used in the case of lack of [`<ruby>`](/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.") element support its content has what should be displayed in order to indicate the presence of a ruby annotation, usually parentheses. |
| [`<rt>`](/en-US/docs/Web/HTML/Element/rt "The HTML <rt> Element embraces pronunciation of characters presented in a ruby annotations, which are used to describe the pronunciation of East Asian characters. This element is always used inside a <ruby> element.") | The **HTML `<rt>` Element** embraces pronunciation of characters presented in a ruby annotations, which are used to describe the pronunciation of East Asian characters. This element is always used inside a [`<ruby>`](/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.") element. |
| [`<rtc>`](/en-US/docs/Web/HTML/Element/rtc "The HTML <rtc> Element embraces semantic annotations of characters presented in a ruby of <rb> elements used inside of <ruby> element. <rb> elements can have both pronunciation (<rt>) and semantic (<rtc>) annotations.") | The **HTML `<rtc>` Element** embraces semantic annotations of characters presented in a ruby of [`<rb>`](/en-US/docs/Web/HTML/Element/rb "The documentation about this has not yet been written; please consider contributing!") elements used inside of [`<ruby>`](/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.") element. [`<rb>`](/en-US/docs/Web/HTML/Element/rb "The documentation about this has not yet been written; please consider contributing!") elements can have both pronunciation ([`<rt>`](/en-US/docs/Web/HTML/Element/rt "The HTML <rt> Element embraces pronunciation of characters presented in a ruby annotations, which are used to describe the pronunciation of East Asian characters. This element is always used inside a <ruby> element.")) and semantic ([`<rtc>`](/en-US/docs/Web/HTML/Element/rtc "The HTML <rtc> Element embraces semantic annotations of characters presented in a ruby of <rb> elements used inside of <ruby> element. <rb> elements can have both pronunciation (<rt>) and semantic (<rtc>) annotations.")) annotations. |
| [`<ruby>`](/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.") | The **HTML `<ruby>` Element** represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters. |
| [`<s>`](/en-US/docs/Web/HTML/Element/s "The HTML Strikethrough Element (<s>) renders text with a strikethrough, or a line through it. Use the <s> element to represent things that are no longer relevant or no longer accurate. However, <s> is not appropriate when indicating document edits; for that, use the <del> and <ins> elements, as appropriate.") | The _HTML Strikethrough Element_ (`<s>`) renders text with a strikethrough, or a line through it. Use the `<s>` element to represent things that are no longer relevant or no longer accurate. However, `<s>` is not appropriate when indicating document edits; for that, use the [`<del>`](/en-US/docs/Web/HTML/Element/del "The HTML Deleted Text Element (<del>) represents a range of text that has been deleted from a document. This element is often (but need not be) rendered with strike-through text.") and [`<ins>`](/en-US/docs/Web/HTML/Element/ins "The HTML <ins> Element (or HTML Inserted Text) HTML represents a range of text that has been added to a document.") elements, as appropriate. |
| [`<samp>`](/en-US/docs/Web/HTML/Element/samp "The HTML <samp> element is an element intended to identify sample output from a computer program. It is usually displayed in the browser's default monotype font (such as Lucida Console).") | The HTML <samp> element is an element intended to identify sample output from a computer program. It is usually displayed in the browser's default monotype font (such as Lucida Console). |
| [`<small>`](/en-US/docs/Web/HTML/Element/small "The HTML Small Element (<small>) makes the text font size one size smaller (for example, from large to medium, or from small to x-small) down to the browser's minimum font size.  In HTML5, this element is repurposed to represent side-comments and small print, including copyright and legal text, independent of its styled presentation.") | The HTML Small Element (<small>) makes the text _font size_ one size smaller (for example, from large to medium, or from small to x-small) down to the browser's minimum font size.  In HTML5, this element is repurposed to represent side-comments and small print, including copyright and legal text, independent of its styled presentation. |
| [`<span>`](/en-US/docs/Web/HTML/Element/span "The HTML <span> element is a generic inline container for phrasing content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the class or id attributes), or because they share attribute values, such as lang.") | The **HTML _`<span>`_ element** is a generic inline container for phrasing content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the `class` or `id` attributes), or because they share attribute values, such as `lang`. |
| [`<strong>`](/en-US/docs/Web/HTML/Element/strong "The HTML <strong> element (or HTML Strong Element) gives text strong importance, and is typically displayed in bold.") | The **HTML `<strong>` element** gives text strong importance, and is typically displayed in bold. |
| [`<sub>`](/en-US/docs/Web/HTML/Element/sub "The HTML Subscript Element (<sub>) defines a span of text that should be displayed, for typographic reasons, lower, and often smaller, than the main span of text.") | The _HTML Subscript Element_ (`<sub>`) defines a span of text that should be displayed, for typographic reasons, lower, and often smaller, than the main span of text. |
| [`<sup>`](/en-US/docs/Web/HTML/Element/sup "The HTML Superscript Element (<sup>) defines a span of text that should be displayed, for typographic reasons, higher, and often smaller, than the main span of text.") | The _HTML Superscript Element_ (`<sup>`) defines a span of text that should be displayed, for typographic reasons, higher, and often smaller, than the main span of text. |
| [`<time>`](/en-US/docs/Web/HTML/Element/time "The HTML <time> element represents either a time on a 24-hour clock or a precise date in the Gregorian calendar (with optional time and timezone information).") | The **HTML `<time>` element** represents either a time on a 24-hour clock or a precise date in the [Gregorian calendar](http://en.wikipedia.org/wiki/Gregorian_calendar "http://en.wikipedia.org/wiki/Gregorian_calendar") (with optional time and timezone information). |
| [`<u>`](/en-US/docs/Web/HTML/Element/u "The HTML Underline Element (<u>) renders text with an underline, a line under the baseline of its content.") | The _HTML Underline Element_ (`<u>`) renders text with an underline, a line under the baseline of its content. |
| [`<var>`](/en-US/docs/Web/HTML/Element/var "The HTML Variable Element (<var>) represents a variable in a mathematical expression or a programming context.") | The HTML Variable Element (`<var>`) represents a variable in a mathematical expression or a programming context. |
| [`<wbr>`](/en-US/docs/Web/HTML/Element/wbr "The HTML element word break opportunity <wbr> represents a position within text where the browser may optionally break a line, though its line-breaking rules would not otherwise create a break at that location.") | The HTML element _word break opportunity_ `<wbr>` represents a position within text where the browser may optionally break a line, though its line-breaking rules would not otherwise create a break at that location. |
