"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A bounce template.
 */
class BounceTemplate {
    constructor(props) {
        this.props = props;
    }
}
exports.BounceTemplate = BounceTemplate;
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1'
});
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4'
});
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2'
});
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1'
});
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0'
});
/**
 * Rejects the received email by returning a bounce response to the sender and,
 * optionally, publishes a notification to Amazon SNS.
 */
class Bounce {
    constructor(props) {
        this.props = props;
    }
    bind(_rule) {
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
                statusCode: this.props.template.props.statusCode
            }
        };
    }
}
exports.Bounce = Bounce;
//# sourceMappingURL=data:application/json;base64,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