"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The type of email encoding to use for a SNS action.
 */
var EmailEncoding;
(function (EmailEncoding) {
    /**
     * Base 64
     */
    EmailEncoding["BASE64"] = "Base64";
    /**
     * UTF-8
     */
    EmailEncoding["UTF8"] = "UTF-8";
})(EmailEncoding = exports.EmailEncoding || (exports.EmailEncoding = {}));
/**
 * Publishes the email content within a notification to Amazon SNS.
 */
class Sns {
    constructor(props) {
        this.props = props;
    }
    bind(_rule) {
        return {
            snsAction: {
                encoding: this.props.encoding,
                topicArn: this.props.topic.topicArn
            }
        };
    }
}
exports.Sns = Sns;
//# sourceMappingURL=data:application/json;base64,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