"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kms = require("@aws-cdk/aws-kms");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const ses = require("@aws-cdk/aws-ses");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const actions = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ses-receipt');
const topic = new sns.Topic(stack, 'Topic');
const fn = new lambda.Function(stack, 'Function', {
    code: lambda.Code.fromInline('exports.handler = async (event) => event;'),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_10_X
});
const bucket = new s3.Bucket(stack, 'Bucket');
const kmsKey = new kms.Key(stack, 'Key');
const ruleSet = new ses.ReceiptRuleSet(stack, 'RuleSet', {
    dropSpam: true
});
const firstRule = ruleSet.addRule('FirstRule', {
    actions: [
        new actions.AddHeader({
            name: 'X-My-Header',
            value: 'value'
        }),
        new actions.Lambda({
            function: fn,
            invocationType: actions.LambdaInvocationType.REQUEST_RESPONSE,
            topic
        }),
        new actions.S3({
            bucket,
            kmsKey,
            objectKeyPrefix: 'emails/',
            topic
        }),
        new actions.Sns({
            encoding: actions.EmailEncoding.BASE64,
            topic
        })
    ],
    receiptRuleName: 'FirstRule',
    recipients: ['cdk-ses-receipt-test@yopmail.com'],
    scanEnabled: true,
    tlsPolicy: ses.TlsPolicy.REQUIRE,
});
firstRule.addAction(new actions.Bounce({
    sender: 'cdk-ses-receipt-test@yopmail.com',
    template: actions.BounceTemplate.MESSAGE_CONTENT_REJECTED,
    topic
}));
const secondRule = ruleSet.addRule('SecondRule');
secondRule.addAction(new actions.Stop({
    topic
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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