# mypy-boto3-mgn

[![PyPI - mypy-boto3-mgn](https://img.shields.io/pypi/v/mypy-boto3-mgn.svg?color=blue)](https://pypi.org/project/mypy-boto3-mgn)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mgn.svg?color=blue)](https://pypi.org/project/mypy-boto3-mgn)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-mgn?color=blue)](https://pypistats.org/packages/mypy-boto3-mgn)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.mgn 1.17.62](https://boto3.amazonaws.com/v1/documentation/api/1.17.62/reference/services/mgn.html#mgn) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.7.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-mgn](#mypy-boto3-mgn)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `mgn` service.

```bash
python -m pip install boto3-stubs[mgn]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[mgn]` in your environment: `python -m pip install 'boto3-stubs[mgn]'`

Both type checking and auto-complete should work for `mgn` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[mgn]` in your environment: `python -m pip install 'boto3-stubs[mgn]'`

Both type checking and auto-complete should work for `mgn` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[mgn]` in your environment: `python -m pip install 'boto3-stubs[mgn]'`
- Run `mypy` as usual

Type checking should work for `mgn` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[mgn]` in your environment: `python -m pip install 'boto3-stubs[mgn]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `mgn` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`mgnClient` provides annotations for `boto3.client("mgn")`.

```python
import boto3

from mypy_boto3_mgn import mgnClient

client: mgnClient = boto3.client("mgn")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: mgnClient = session.client("mgn")
```

### Paginators annotations

`mypy_boto3_mgn.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_mgn import mgnClient
from mypy_boto3_mgn.paginator import (
    DescribeJobLogItemsPaginator,
    DescribeJobsPaginator,
    DescribeReplicationConfigurationTemplatesPaginator,
    DescribeSourceServersPaginator,
)

client: mgnClient = boto3.client("mgn")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_job_log_items_paginator: DescribeJobLogItemsPaginator = client.get_paginator("describe_job_log_items")
describe_jobs_paginator: DescribeJobsPaginator = client.get_paginator("describe_jobs")
describe_replication_configuration_templates_paginator: DescribeReplicationConfigurationTemplatesPaginator = client.get_paginator("describe_replication_configuration_templates")
describe_source_servers_paginator: DescribeSourceServersPaginator = client.get_paginator("describe_source_servers")
```







### Literals

`mypy_boto3_mgn.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_mgn.literals import (
    ChangeServerLifeCycleStateSourceServerLifecycleState,
    DataReplicationErrorString,
    DataReplicationInitiationStepName,
    DataReplicationInitiationStepStatus,
    DataReplicationState,
    DescribeJobLogItemsPaginatorName,
    DescribeJobsPaginatorName,
    DescribeReplicationConfigurationTemplatesPaginatorName,
    DescribeSourceServersPaginatorName,
    FirstBoot,
    InitiatedBy,
    JobLogEvent,
    JobStatus,
    JobType,
    LaunchDisposition,
    LaunchStatus,
    LifeCycleState,
    ReplicationConfigurationDataPlaneRouting,
    ReplicationConfigurationDefaultLargeStagingDiskType,
    ReplicationConfigurationEbsEncryption,
    ReplicationConfigurationReplicatedDiskStagingDiskType,
    TargetInstanceTypeRightSizingMethod,
)

def check_value(value: ChangeServerLifeCycleStateSourceServerLifecycleState) -> bool:
    ...
```



### Typed dictionaries

`mypy_boto3_mgn.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_mgn.type_defs import (
    CPUTypeDef,
    DataReplicationErrorTypeDef,
    DataReplicationInfoReplicatedDiskTypeDef,
    DataReplicationInfoTypeDef,
    DataReplicationInitiationStepTypeDef,
    DataReplicationInitiationTypeDef,
    DiskTypeDef,
    IdentificationHintsTypeDef,
    JobLogEventDataTypeDef,
    JobLogTypeDef,
    JobTypeDef,
    LaunchedInstanceTypeDef,
    LicensingTypeDef,
    LifeCycleLastCutoverFinalizedTypeDef,
    LifeCycleLastCutoverInitiatedTypeDef,
    LifeCycleLastCutoverRevertedTypeDef,
    LifeCycleLastCutoverTypeDef,
    LifeCycleLastTestFinalizedTypeDef,
    LifeCycleLastTestInitiatedTypeDef,
    LifeCycleLastTestRevertedTypeDef,
    LifeCycleLastTestTypeDef,
    LifeCycleTypeDef,
    NetworkInterfaceTypeDef,
    OSTypeDef,
    ParticipatingServerTypeDef,
    ReplicationConfigurationReplicatedDiskTypeDef,
    ReplicationConfigurationTemplateTypeDef,
    SourcePropertiesTypeDef,
    SourceServerTypeDef,
    ChangeServerLifeCycleStateSourceServerLifecycleTypeDef,
    DescribeJobLogItemsResponseTypeDef,
    DescribeJobsRequestFiltersTypeDef,
    DescribeJobsResponseTypeDef,
    DescribeReplicationConfigurationTemplatesResponseTypeDef,
    DescribeSourceServersRequestFiltersTypeDef,
    DescribeSourceServersResponseTypeDef,
    LaunchConfigurationTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    ReplicationConfigurationTypeDef,
    StartCutoverResponseTypeDef,
    StartTestResponseTypeDef,
    TerminateTargetInstancesResponseTypeDef,
)

def get_structure() -> CPUTypeDef:
    return {
      ...
    }
```
