"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeCommitSourceCodeProvider = exports.GitLabSourceCodeProvider = exports.GitHubSourceCodeProvider = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * GitHub source code provider
 */
class GitHubSourceCodeProvider {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_GitHubSourceCodeProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GitHubSourceCodeProvider);
            }
            throw error;
        }
    }
    bind(_app) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(_app);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            repository: `https://github.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitHubSourceCodeProvider = GitHubSourceCodeProvider;
_a = JSII_RTTI_SYMBOL_1;
GitHubSourceCodeProvider[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.GitHubSourceCodeProvider", version: "2.40.0-alpha.0" };
/**
 * GitLab source code provider
 */
class GitLabSourceCodeProvider {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_GitLabSourceCodeProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GitLabSourceCodeProvider);
            }
            throw error;
        }
    }
    bind(_app) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(_app);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            repository: `https://gitlab.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitLabSourceCodeProvider = GitLabSourceCodeProvider;
_b = JSII_RTTI_SYMBOL_1;
GitLabSourceCodeProvider[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.GitLabSourceCodeProvider", version: "2.40.0-alpha.0" };
/**
 * CodeCommit source code provider
 */
class CodeCommitSourceCodeProvider {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CodeCommitSourceCodeProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeCommitSourceCodeProvider);
            }
            throw error;
        }
    }
    bind(app) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(app);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.props.repository.grantPull(app);
        return {
            repository: this.props.repository.repositoryCloneUrlHttp,
        };
    }
}
exports.CodeCommitSourceCodeProvider = CodeCommitSourceCodeProvider;
_c = JSII_RTTI_SYMBOL_1;
CodeCommitSourceCodeProvider[_c] = { fqn: "@aws-cdk/aws-amplify-alpha.CodeCommitSourceCodeProvider", version: "2.40.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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