"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicAuth = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("aws-cdk-lib/aws-secretsmanager");
/**
 * Basic Auth configuration
 */
class BasicAuth {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BasicAuthProps(props);
    }
    /**
     * Creates a Basic Auth configuration from a username and a password
     *
     * @param username The username
     * @param password The password
     */
    static fromCredentials(username, password) {
        return new BasicAuth({ username, password });
    }
    /**
     * Creates a Basic Auth configuration with a password generated in Secrets
     * Manager.
     *
     * @param username The username
     * @param encryptionKey The encryption key to use to encrypt the password in
     * Secrets Manager
     */
    static fromGeneratedPassword(username, encryptionKey) {
        return new BasicAuth({ username, encryptionKey });
    }
    /**
     * Binds this Basic Auth configuration to an App
     */
    bind(scope, id) {
        const config = {
            enableBasicAuth: true,
            username: this.props.username,
        };
        if (this.props.password) {
            return {
                ...config,
                password: this.props.password.toString(),
            };
        }
        const secret = new secretsmanager.Secret(scope, id, {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({ username: this.props.username }),
                generateStringKey: 'password',
            },
        });
        return {
            ...config,
            password: secret.secretValueFromJson('password').toString(),
        };
    }
}
exports.BasicAuth = BasicAuth;
_a = JSII_RTTI_SYMBOL_1;
BasicAuth[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.BasicAuth", version: "2.18.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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