// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
import React, { useEffect } from 'react';
import DefaultTaskpane from '../DefaultTaskpane/DefaultTaskpane';
import Search from './Search';
import DefaultTaskpaneHeader from '../DefaultTaskpane/DefaultTaskpaneHeader';
import DefaultTaskpaneBody from '../DefaultTaskpane/DefaultTaskpaneBody';
/*
    A taskpane that allows a user to search a value in the sheet
*/
const SearchTaskpane = (props) => {
    // When the Search Taskpane is closed, clear the search term
    useEffect(() => {
        return () => {
            props.setGridState(prevGridState => {
                return Object.assign(Object.assign({}, prevGridState), { searchString: '' });
            });
        };
    }, []);
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: 'Search Values in Sheet', setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement(Search, { gridState: props.gridState, sheetData: props.sheetData, setGridState: props.setGridState, mitoAPI: props.mitoAPI, mitoContainerRef: props.mitoContainerRef, uiState: props.uiState }))));
};
export default SearchTaskpane;
//# sourceMappingURL=SearchTaskpane.js.map