import { DOMWidgetModel, DOMWidgetView, } from '@jupyter-widgets/base';
import { MODULE_NAME, MODULE_VERSION } from './version';
// React
import React from 'react';
import ReactDOM from 'react-dom';
// Components
import Mito from './components/Mito';
export class ExampleModel extends DOMWidgetModel {
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: ExampleModel.model_name, _model_module: ExampleModel.model_module, _model_module_version: ExampleModel.model_module_version, _view_name: ExampleModel.view_name, _view_module: ExampleModel.view_module, _view_module_version: ExampleModel.view_module_version, df_json: '' });
    }
}
ExampleModel.serializers = Object.assign({}, DOMWidgetModel.serializers);
ExampleModel.model_name = 'ExampleModel';
ExampleModel.model_module = MODULE_NAME;
ExampleModel.model_module_version = MODULE_VERSION;
ExampleModel.view_name = 'ExampleView'; // Set to null if no view
ExampleModel.view_module = MODULE_NAME; // Set to null if no view
ExampleModel.view_module_version = MODULE_VERSION;
import MitoAPI from './api';
import { ModalEnum } from './components/modals/modals';
export class ExampleView extends DOMWidgetView {
    initialize(parameters) {
        super.initialize(parameters);
        // Bind the functions we pass down to other classes
        this.send = this.send.bind(this);
        this.updateMitoState = this.updateMitoState.bind(this);
        this.setErrorModal = this.setErrorModal.bind(this);
        this.creationSeconds = new Date().getSeconds();
    }
    /*
        We override the sending message utilities, just to make sure that
        this is captured properly
    */
    send(msg) {
        super.send(msg);
    }
    render() {
        const model_id = this.model.model_id;
        const mitoAPI = new MitoAPI(model_id, this.send, this.updateMitoState, this.setErrorModal);
        // Store the API in a global map so we can receive messages on it
        if (window.mitoAPIMap === undefined) {
            window.mitoAPIMap = new Map();
        }
        window.mitoAPIMap.set(model_id, mitoAPI);
        // Get the initial sheet data, analysis data, and user profile
        const sheetDataArray = this.getSheetDataArray();
        const analysisData = this.getAnalysisData();
        const userProfile = this.getUserProfile();
        ReactDOM.render(React.createElement(Mito, { model_id: model_id, mitoAPI: mitoAPI, sheetDataArray: sheetDataArray, analysisData: analysisData, userProfile: userProfile }), this.el);
        this.model.on('msg:custom', this.handleMessage, this);
    }
    /*
        This is the function actually responsible for updating the Mito component
        with the new state, and is called by the MitoAPI when it receives a successful
        response from the backend!
    */
    updateMitoState() {
        var _a;
        const model_id = this.model.model_id;
        const stateUpdaters = (_a = window.setMitoStateMap) === null || _a === void 0 ? void 0 : _a.get(model_id);
        if (stateUpdaters === undefined) {
            return;
        }
        const sheetDataArray = this.getSheetDataArray();
        const analysisData = this.getAnalysisData();
        const userProfile = this.getUserProfile();
        // TODO: set analysis data, update user profile
        stateUpdaters.setSheetDataArray(sheetDataArray);
        stateUpdaters.setAnalysisData(analysisData);
        stateUpdaters.setUserProfile(userProfile);
    }
    /*
        Sets the current error modal on the Mito instance, which is useful
        (for now) when the frontend recieves a response that means an
        operation failed.

        This function should die once we start handling errors in place.
    */
    setErrorModal(error) {
        var _a;
        const model_id = this.model.model_id;
        const stateUpdaters = (_a = window.setMitoStateMap) === null || _a === void 0 ? void 0 : _a.get(model_id);
        stateUpdaters === null || stateUpdaters === void 0 ? void 0 : stateUpdaters.setUIState((prevUIState => {
            return Object.assign(Object.assign({}, prevUIState), { currOpenModal: {
                    type: ModalEnum.Error,
                    error: error
                } });
        }));
    }
    /*
        This route handles the messages sent from the Python widget, and mostly
        is just responsible for forwarding it to the correct Mito API.

        See the MitoAPI class comments for a full description of how the API process
        works and why it is designed the way it is.
    */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/explicit-module-boundary-types
    handleMessage(message) {
        var _a;
        const model_id = this.model.model_id;
        const mitoAPI = (_a = window.mitoAPIMap) === null || _a === void 0 ? void 0 : _a.get(model_id);
        mitoAPI === null || mitoAPI === void 0 ? void 0 : mitoAPI.receiveResponse(message);
    }
    getSheetDataArray() {
        const unparsed = this.model.get('sheet_data_json');
        return JSON.parse(unparsed);
    }
    getUserProfile() {
        const unparsed = this.model.get('user_profile_json');
        const userProfile = JSON.parse(unparsed);
        if (userProfile['usageTriggeredFeedbackID'] == '') {
            userProfile['usageTriggeredFeedbackID'] = undefined;
        }
        return userProfile;
    }
    getAnalysisData() {
        const unparsed = this.model.get('analysis_data_json');
        return JSON.parse(unparsed);
    }
}
//# sourceMappingURL=widget.js.map