import * as cdk from '@aws-cdk/core';
import * as lambda from '@aws-cdk/aws-lambda';
/**
 * Construct properties for `ServerlessApi`
 */
export interface ServerlessApiProps {
    /**
     * custom lambda function for the API
     *
     * @default - A Lambda function with Lavavel and Bref support will be created
     */
    readonly handler?: lambda.IFunction;
    /**
     * custom lambda code asset path
     *
     * @default - DEFAULT_LAMBDA_ASSET_PATH
     */
    readonly lambdaCodePath?: string;
    /**
     * AWS Lambda layer version from the Bref runtime.
     * e.g. arn:aws:lambda:us-west-1:209497400698:layer:php-74-fpm:12
     * check the latest runtime verion arn at https://bref.sh/docs/runtimes/
     */
    readonly brefLayerVersion: string;
}
/**
 * Use `ServerlessApi` to create the serverless API resource
 */
export declare class ServerlessApi extends cdk.Construct {
    readonly handler: lambda.IFunction;
    constructor(scope: cdk.Construct, id: string, props: ServerlessApiProps);
}
/**
 * Construct properties for `ServerlessLaravel`
 */
export interface ServerlessLaravelProps extends ServerlessApiProps {
    /**
     * path to your local laravel directory with bref
     */
    readonly laravelPath: string;
}
/**
 * Use `ServerlessLaravel` to create the serverless Laravel resource
 */
export declare class ServerlessLaravel extends ServerlessApi {
    constructor(scope: cdk.Construct, id: string, props: ServerlessLaravelProps);
}
