"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("../");
const core_1 = require("@aws-cdk/core");
require("@aws-cdk/assert/jest");
test('create the ServerlessAPI', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    new __1.ServerlessApi(stack, 'testing', {
        brefLayerVersion: 'arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74-fpm:11',
    });
    expect(stack).toHaveResource('AWS::ApiGatewayV2::Api');
    expect(stack).toHaveResource('AWS::Lambda::Function');
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXgudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy90ZXN0L2luZGV4LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSwyQkFBb0M7QUFDcEMsd0NBQTJDO0FBQzNDLGdDQUE4QjtBQUU5QixJQUFJLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxFQUFFO0lBQ3BDLE1BQU0sT0FBTyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7SUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLENBQUMsT0FBTyxFQUFFLGVBQWUsQ0FBQyxDQUFDO0lBRWxELElBQUksaUJBQWEsQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFO1FBQ2xDLGdCQUFnQixFQUFFLGdFQUFnRTtLQUNuRixDQUFDLENBQUM7SUFFSCxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsY0FBYyxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDdkQsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLGNBQWMsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0FBQ3hELENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU2VydmVybGVzc0FwaSB9IGZyb20gJy4uLyc7XG5pbXBvcnQgeyBBcHAsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgJ0Bhd3MtY2RrL2Fzc2VydC9qZXN0JztcblxudGVzdCgnY3JlYXRlIHRoZSBTZXJ2ZXJsZXNzQVBJJywgKCkgPT4ge1xuICBjb25zdCBtb2NrQXBwID0gbmV3IEFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBTdGFjayhtb2NrQXBwLCAndGVzdGluZy1zdGFjaycpO1xuXG4gIG5ldyBTZXJ2ZXJsZXNzQXBpKHN0YWNrLCAndGVzdGluZycsIHtcbiAgICBicmVmTGF5ZXJWZXJzaW9uOiAnYXJuOmF3czpsYW1iZGE6YXAtbm9ydGhlYXN0LTE6MjA5NDk3NDAwNjk4OmxheWVyOnBocC03NC1mcG06MTEnLFxuICB9KTtcblxuICBleHBlY3Qoc3RhY2spLnRvSGF2ZVJlc291cmNlKCdBV1M6OkFwaUdhdGV3YXlWMjo6QXBpJyk7XG4gIGV4cGVjdChzdGFjaykudG9IYXZlUmVzb3VyY2UoJ0FXUzo6TGFtYmRhOjpGdW5jdGlvbicpO1xufSk7XG5cblxuXG4iXX0=