import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * This resource allows to create, read, update and delete a network peering
 *
 * @schema CfnNetworkPeeringProps
 */
export interface CfnNetworkPeeringProps {
    /**
     * The unique identifier of the project.
     *
     * @schema CfnNetworkPeeringProps#ProjectId
     */
    readonly projectId: string;
    /**
     * Unique identifier of the Atlas VPC container for the AWS region.
     *
     * @schema CfnNetworkPeeringProps#ContainerId
     */
    readonly containerId?: string;
    /**
     * AWS region where the peer VPC resides. Returns null if the region is the same region in which the Atlas VPC resides.
     *
     * @schema CfnNetworkPeeringProps#AccepterRegionName
     */
    readonly accepterRegionName?: string;
    /**
     * AWS account ID of the owner of the peer VPC.
     *
     * @schema CfnNetworkPeeringProps#AwsAccountId
     */
    readonly awsAccountId?: string;
    /**
     * The name of the provider
     *
     * @schema CfnNetworkPeeringProps#ProviderName
     */
    readonly providerName?: string;
    /**
     * Peer VPC CIDR block or subnet.
     *
     * @schema CfnNetworkPeeringProps#RouteTableCIDRBlock
     */
    readonly routeTableCidrBlock?: string;
    /**
     * Unique identifier of the peer VPC.
     *
     * @schema CfnNetworkPeeringProps#VpcId
     */
    readonly vpcId: string;
    /**
     * Unique identifier for the peering connection.
     *
     * @schema CfnNetworkPeeringProps#ConnectionId
     */
    readonly connectionId?: string;
    /**
     * @schema CfnNetworkPeeringProps#ApiKeys
     */
    readonly apiKeys: ApiKeyDefinition;
}
/**
 * Converts an object of type 'CfnNetworkPeeringProps' to JSON representation.
 */
export declare function toJson_CfnNetworkPeeringProps(obj: CfnNetworkPeeringProps | undefined): Record<string, any> | undefined;
/**
 * @schema apiKeyDefinition
 */
export interface ApiKeyDefinition {
    /**
     * @schema apiKeyDefinition#PublicKey
     */
    readonly publicKey?: string;
    /**
     * @schema apiKeyDefinition#PrivateKey
     */
    readonly privateKey?: string;
}
/**
 * Converts an object of type 'ApiKeyDefinition' to JSON representation.
 */
export declare function toJson_ApiKeyDefinition(obj: ApiKeyDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `MongoDB::Atlas::NetworkPeering`
 *
 * @cloudformationResource MongoDB::Atlas::NetworkPeering
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnNetworkPeering extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "MongoDB::Atlas::NetworkPeering";
    /**
     * Resource props.
     */
    readonly props: CfnNetworkPeeringProps;
    /**
     * Attribute `MongoDB::Atlas::NetworkPeering.Id`
     * @link http://unknown-url
     */
    readonly attrId: string;
    /**
     * Attribute `MongoDB::Atlas::NetworkPeering.StatusName`
     * @link http://unknown-url
     */
    readonly attrStatusName: string;
    /**
     * Attribute `MongoDB::Atlas::NetworkPeering.ErrorStateName`
     * @link http://unknown-url
     */
    readonly attrErrorStateName: string;
    /**
     * Create a new `MongoDB::Atlas::NetworkPeering`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnNetworkPeeringProps);
}
