"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnNetworkPeering = exports.toJson_ApiKeyDefinition = exports.toJson_CfnNetworkPeeringProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnNetworkPeeringProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnNetworkPeeringProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ProjectId': obj.projectId,
        'ContainerId': obj.containerId,
        'AccepterRegionName': obj.accepterRegionName,
        'AwsAccountId': obj.awsAccountId,
        'ProviderName': obj.providerName,
        'RouteTableCIDRBlock': obj.routeTableCidrBlock,
        'VpcId': obj.vpcId,
        'ConnectionId': obj.connectionId,
        'ApiKeys': toJson_ApiKeyDefinition(obj.apiKeys),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnNetworkPeeringProps = toJson_CfnNetworkPeeringProps;
/**
 * Converts an object of type 'ApiKeyDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ApiKeyDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'PublicKey': obj.publicKey,
        'PrivateKey': obj.privateKey,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ApiKeyDefinition = toJson_ApiKeyDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `MongoDB::Atlas::NetworkPeering`
 *
 * @cloudformationResource MongoDB::Atlas::NetworkPeering
 * @stability external
 * @link http://unknown-url
 */
class CfnNetworkPeering extends cdk.CfnResource {
    /**
     * Create a new `MongoDB::Atlas::NetworkPeering`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNetworkPeering.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnNetworkPeeringProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrStatusName = cdk.Token.asString(this.getAtt('StatusName'));
        this.attrErrorStateName = cdk.Token.asString(this.getAtt('ErrorStateName'));
    }
}
exports.CfnNetworkPeering = CfnNetworkPeering;
_a = JSII_RTTI_SYMBOL_1;
CfnNetworkPeering[_a] = { fqn: "@cdk-cloudformation/mongodb-atlas-networkpeering.CfnNetworkPeering", version: "1.2.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnNetworkPeering.CFN_RESOURCE_TYPE_NAME = "MongoDB::Atlas::NetworkPeering";
//# sourceMappingURL=data:application/json;base64,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