"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = void 0;
const integration_1 = require("../integration");
/**
 * You can integrate an API method with an HTTP endpoint using the HTTP proxy integration or the HTTP custom integration,.
 *
 * With the proxy integration, the setup is simple. You only need to set the
 * HTTP method and the HTTP endpoint URI, according to the backend requirements,
 * if you are not concerned with content encoding or caching.
 *
 * With the custom integration, the setup is more involved. In addition to the
 * proxy integration setup steps, you need to specify how the incoming request
 * data is mapped to the integration request and how the resulting integration
 * response data is mapped to the method response.
 *
 * @stability stable
 */
class HttpIntegration extends integration_1.Integration {
    /**
     * @stability stable
     */
    constructor(url, props = {}) {
        var _a;
        const proxy = (_a = props.proxy) !== null && _a !== void 0 ? _a : true;
        const method = props.httpMethod || 'GET';
        super({
            type: proxy ? integration_1.IntegrationType.HTTP_PROXY : integration_1.IntegrationType.HTTP,
            integrationHttpMethod: method,
            uri: url,
            options: props.options,
        });
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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