"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const awsLambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const pjson = require('/package.json');
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, params) {
        super(scope, id);
        /**
         * @stability stable
         */
        this.objectCodeKey = pjson.version;
        this.flywayLambdaMigration = new awsLambda.Function(this, id, {
            vpc: params.vpc,
            vpcSubnets: params.subnet,
            securityGroups: params.securityGroups,
            memorySize: params.memorySize || 512,
            timeout: params.timeout || cdk.Duration.seconds(30),
            handler: FlywayConstruct.HANDLER,
            runtime: awsLambda.Runtime.JAVA_11,
            environment: {
                ARN: params.migrationDBSecretManager.secretArn,
                BUCKET_NAME: params.bucketMigrationSQL.bucketName,
            },
            code: awsLambda.S3Code.fromBucket(s3.Bucket.fromBucketArn(this, FlywayConstruct.ID_LAMBDA_CODE, FlywayConstruct.BUCKET_CODE_ARN), 'flywayjar.' + this.objectCodeKey + '.zip'),
        });
        params.migrationDBSecretManager.grantRead(this.flywayLambdaMigration);
        params.bucketMigrationSQL.grantRead(this.flywayLambdaMigration);
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstruct.FlywayConstruct", version: "0.2.20" };
/**
 * @stability stable
 */
FlywayConstruct.HANDLER = 'tech.necko.flywayjar.Main::handleRequest';
/**
 * @stability stable
 */
FlywayConstruct.ID_LAMBDA_CODE = 'bucketMigration';
/**
 * @stability stable
 */
FlywayConstruct.BUCKET_CODE_ARN = 'arn:aws:s3:::flywaymigrationconstruct';
//# sourceMappingURL=data:application/json;base64,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