"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddHeader = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Adds a header to the received email
 */
class AddHeader {
    constructor(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_AddHeaderProps(props);
        if (!/^[a-zA-Z0-9-]{1,50}$/.test(props.name)) {
            // eslint-disable-next-line max-len
            throw new Error('Header `name` must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.');
        }
        if (!/^[^\n\r]{0,2047}$/.test(props.value)) {
            throw new Error('Header `value` must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").');
        }
        this.name = props.name;
        this.value = props.value;
    }
    bind(_rule) {
        return {
            addHeaderAction: {
                headerName: this.name,
                headerValue: this.value,
            },
        };
    }
}
exports.AddHeader = AddHeader;
_a = JSII_RTTI_SYMBOL_1;
AddHeader[_a] = { fqn: "@aws-cdk/aws-ses-actions.AddHeader", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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