"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A bounce template.
 */
class BounceTemplate {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_BounceTemplateProps(props);
    }
}
exports.BounceTemplate = BounceTemplate;
_a = JSII_RTTI_SYMBOL_1;
BounceTemplate[_a] = { fqn: "@aws-cdk/aws-ses-actions.BounceTemplate", version: "1.147.0" };
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * Rejects the received email by returning a bounce response to the sender and,
 * optionally, publishes a notification to Amazon SNS.
 */
class Bounce {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_BounceProps(props);
    }
    bind(_rule) {
        var _c;
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: (_c = this.props.topic) === null || _c === void 0 ? void 0 : _c.topicArn,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
_b = JSII_RTTI_SYMBOL_1;
Bounce[_b] = { fqn: "@aws-cdk/aws-ses-actions.Bounce", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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