"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.arbitrary_complete_intervals = exports.ArbitraryCompleteIntervals = void 0;
const fc = require("fast-check");
const scalingcommon = require("../lib");
class ArbitraryCompleteIntervals extends fc.Arbitrary {
    generate(mrng) {
        const ret = scalingcommon.generateArbitraryIntervals(mrng);
        return new fc.Shrinkable(scalingcommon.normalizeIntervals(ret.intervals, ret.absolute));
    }
}
exports.ArbitraryCompleteIntervals = ArbitraryCompleteIntervals;
function arbitrary_complete_intervals() {
    return new ArbitraryCompleteIntervals();
}
exports.arbitrary_complete_intervals = arbitrary_complete_intervals;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsaUNBQWlDO0FBQ2pDLHdDQUF3QztBQUV4QyxNQUFhLDBCQUEyQixTQUFRLEVBQUUsQ0FBQyxTQUFrRDtJQUM1RixRQUFRLENBQUMsSUFBZTtRQUM3QixNQUFNLEdBQUcsR0FBRyxhQUFhLENBQUMsMEJBQTBCLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDM0QsT0FBTyxJQUFJLEVBQUUsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDMUYsQ0FBQztDQUNGO0FBTEQsZ0VBS0M7QUFFRCxTQUFnQiw0QkFBNEI7SUFDMUMsT0FBTyxJQUFJLDBCQUEwQixFQUFFLENBQUM7QUFDMUMsQ0FBQztBQUZELG9FQUVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZmMgZnJvbSAnZmFzdC1jaGVjayc7XG5pbXBvcnQgKiBhcyBzY2FsaW5nY29tbW9uIGZyb20gJy4uL2xpYic7XG5cbmV4cG9ydCBjbGFzcyBBcmJpdHJhcnlDb21wbGV0ZUludGVydmFscyBleHRlbmRzIGZjLkFyYml0cmFyeTxzY2FsaW5nY29tbW9uLkNvbXBsZXRlU2NhbGluZ0ludGVydmFsW10+IHtcbiAgcHVibGljIGdlbmVyYXRlKG1ybmc6IGZjLlJhbmRvbSk6IGZjLlNocmlua2FibGU8c2NhbGluZ2NvbW1vbi5Db21wbGV0ZVNjYWxpbmdJbnRlcnZhbFtdPiB7XG4gICAgY29uc3QgcmV0ID0gc2NhbGluZ2NvbW1vbi5nZW5lcmF0ZUFyYml0cmFyeUludGVydmFscyhtcm5nKTtcbiAgICByZXR1cm4gbmV3IGZjLlNocmlua2FibGUoc2NhbGluZ2NvbW1vbi5ub3JtYWxpemVJbnRlcnZhbHMocmV0LmludGVydmFscywgcmV0LmFic29sdXRlKSk7XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGFyYml0cmFyeV9jb21wbGV0ZV9pbnRlcnZhbHMoKSB7XG4gIHJldHVybiBuZXcgQXJiaXRyYXJ5Q29tcGxldGVJbnRlcnZhbHMoKTtcbn1cbiJdfQ==