import { Resource, ResourceProps } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { AuthorizationType } from './method';
/**
 * Base class for all custom authorizers.
 */
export declare abstract class Authorizer extends Resource implements IAuthorizer {
    /**
     * Return whether the given object is an Authorizer.
     */
    static isAuthorizer(x: any): x is Authorizer;
    /**
     * The authorizer ID.
     */
    abstract readonly authorizerId: string;
    /**
     * The authorization type of this authorizer.
     */
    readonly authorizationType?: AuthorizationType;
    /**
     *
     */
    constructor(scope: Construct, id: string, props?: ResourceProps);
}
/**
 * Represents an API Gateway authorizer.
 */
export interface IAuthorizer {
    /**
     * The authorizer ID.
     *
     * @attribute true
     */
    readonly authorizerId: string;
    /**
     * The authorization type of this authorizer.
     */
    readonly authorizationType?: AuthorizationType;
}
