import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The base domain of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#domain GroupCluster#domain}
    */
    readonly domain?: string;
    /**
    * Determines if cluster is active or not. Defaults to `true`. This attribute cannot be read.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#enabled GroupCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The associated environment to the cluster. Defaults to `*`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#environment_scope GroupCluster#environment_scope}
    */
    readonly environmentScope?: string;
    /**
    * The id of the group to add the cluster to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#group GroupCluster#group}
    */
    readonly group: string;
    /**
    * The URL to access the Kubernetes API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#kubernetes_api_url GroupCluster#kubernetes_api_url}
    */
    readonly kubernetesApiUrl: string;
    /**
    * The cluster authorization type. Valid values are `rbac`, `abac`, `unknown_authorization`. Defaults to `rbac`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#kubernetes_authorization_type GroupCluster#kubernetes_authorization_type}
    */
    readonly kubernetesAuthorizationType?: string;
    /**
    * TLS certificate (needed if API is using a self-signed TLS certificate).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#kubernetes_ca_cert GroupCluster#kubernetes_ca_cert}
    */
    readonly kubernetesCaCert?: string;
    /**
    * The token to authenticate against Kubernetes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#kubernetes_token GroupCluster#kubernetes_token}
    */
    readonly kubernetesToken: string;
    /**
    * Determines if cluster is managed by gitlab or not. Defaults to `true`. This attribute cannot be read.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#managed GroupCluster#managed}
    */
    readonly managed?: boolean | cdktf.IResolvable;
    /**
    * The ID of the management project for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#management_project_id GroupCluster#management_project_id}
    */
    readonly managementProjectId?: string;
    /**
    * The name of cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster#name GroupCluster#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster gitlab_group_cluster}
*/
export declare class GroupCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_cluster gitlab_group_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupClusterConfig
    */
    constructor(scope: Construct, id: string, config: GroupClusterConfig);
    get clusterType(): string;
    get createdAt(): string;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _environmentScope?;
    get environmentScope(): string;
    set environmentScope(value: string);
    resetEnvironmentScope(): void;
    get environmentScopeInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get id(): string;
    private _kubernetesApiUrl?;
    get kubernetesApiUrl(): string;
    set kubernetesApiUrl(value: string);
    get kubernetesApiUrlInput(): string | undefined;
    private _kubernetesAuthorizationType?;
    get kubernetesAuthorizationType(): string;
    set kubernetesAuthorizationType(value: string);
    resetKubernetesAuthorizationType(): void;
    get kubernetesAuthorizationTypeInput(): string | undefined;
    private _kubernetesCaCert?;
    get kubernetesCaCert(): string;
    set kubernetesCaCert(value: string);
    resetKubernetesCaCert(): void;
    get kubernetesCaCertInput(): string | undefined;
    private _kubernetesToken?;
    get kubernetesToken(): string;
    set kubernetesToken(value: string);
    get kubernetesTokenInput(): string | undefined;
    private _managed?;
    get managed(): boolean | cdktf.IResolvable;
    set managed(value: boolean | cdktf.IResolvable);
    resetManaged(): void;
    get managedInput(): boolean | cdktf.IResolvable | undefined;
    private _managementProjectId?;
    get managementProjectId(): string;
    set managementProjectId(value: string);
    resetManagementProjectId(): void;
    get managementProjectIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformType(): string;
    get providerType(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
