import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LabelConfig extends cdktf.TerraformMetaArguments {
    /**
    * The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/label#color Label#color}
    */
    readonly color: string;
    /**
    * The description of the label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/label#description Label#description}
    */
    readonly description?: string;
    /**
    * The name of the label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/label#name Label#name}
    */
    readonly name: string;
    /**
    * The name or id of the project to add the label to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/label#project Label#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/label gitlab_label}
*/
export declare class Label extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_label";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/label gitlab_label} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LabelConfig
    */
    constructor(scope: Construct, id: string, config: LabelConfig);
    private _color?;
    get color(): string;
    set color(value: string);
    get colorInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
