import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectCustomAttributeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Key for the Custom Attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_custom_attribute#key ProjectCustomAttribute#key}
    */
    readonly key: string;
    /**
    * The id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_custom_attribute#project ProjectCustomAttribute#project}
    */
    readonly project: number;
    /**
    * Value for the Custom Attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_custom_attribute#value ProjectCustomAttribute#value}
    */
    readonly value: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_custom_attribute gitlab_project_custom_attribute}
*/
export declare class ProjectCustomAttribute extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_custom_attribute";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_custom_attribute gitlab_project_custom_attribute} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectCustomAttributeConfig
    */
    constructor(scope: Construct, id: string, config: ProjectCustomAttributeConfig);
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _project?;
    get project(): number;
    set project(value: number);
    get projectInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
