import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SystemHookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Do SSL verification when triggering the hook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook#enable_ssl_verification SystemHook#enable_ssl_verification}
    */
    readonly enableSslVerification?: boolean | cdktf.IResolvable;
    /**
    * Trigger hook on merge requests events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook#merge_requests_events SystemHook#merge_requests_events}
    */
    readonly mergeRequestsEvents?: boolean | cdktf.IResolvable;
    /**
    * When true, the hook fires on push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook#push_events SystemHook#push_events}
    */
    readonly pushEvents?: boolean | cdktf.IResolvable;
    /**
    * Trigger hook on repository update events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook#repository_update_events SystemHook#repository_update_events}
    */
    readonly repositoryUpdateEvents?: boolean | cdktf.IResolvable;
    /**
    * When true, the hook fires on new tags being pushed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook#tag_push_events SystemHook#tag_push_events}
    */
    readonly tagPushEvents?: boolean | cdktf.IResolvable;
    /**
    * Secret token to validate received payloads; this isn’t returned in the response. This attribute is not available for imported resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook#token SystemHook#token}
    */
    readonly token?: string;
    /**
    * The hook URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook#url SystemHook#url}
    */
    readonly url: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook gitlab_system_hook}
*/
export declare class SystemHook extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_system_hook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/system_hook gitlab_system_hook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SystemHookConfig
    */
    constructor(scope: Construct, id: string, config: SystemHookConfig);
    get createdAt(): string;
    private _enableSslVerification?;
    get enableSslVerification(): boolean | cdktf.IResolvable;
    set enableSslVerification(value: boolean | cdktf.IResolvable);
    resetEnableSslVerification(): void;
    get enableSslVerificationInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _mergeRequestsEvents?;
    get mergeRequestsEvents(): boolean | cdktf.IResolvable;
    set mergeRequestsEvents(value: boolean | cdktf.IResolvable);
    resetMergeRequestsEvents(): void;
    get mergeRequestsEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _pushEvents?;
    get pushEvents(): boolean | cdktf.IResolvable;
    set pushEvents(value: boolean | cdktf.IResolvable);
    resetPushEvents(): void;
    get pushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _repositoryUpdateEvents?;
    get repositoryUpdateEvents(): boolean | cdktf.IResolvable;
    set repositoryUpdateEvents(value: boolean | cdktf.IResolvable);
    resetRepositoryUpdateEvents(): void;
    get repositoryUpdateEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagPushEvents?;
    get tagPushEvents(): boolean | cdktf.IResolvable;
    set tagPushEvents(value: boolean | cdktf.IResolvable);
    resetTagPushEvents(): void;
    get tagPushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
