#!/usr/bin/env python
# -*- coding: utf-8 -*-

#                                                           
# Copyright (C)2017 SenseDeal AI, Inc. All Rights Reserved  
#                                                           

"""                                                   
File: test_all.py
Author: lzl
E-mail: zll@sensedeal.ai
Last modified: 2019/11/25
Description:                                              
"""

from text_etl import handle_text


def get_content(file_name):
    """
    对现有demo进行测试，直到断言不抛出异常
    :param file_name:
    :return:
    """
    with open(file_name, 'r') as f:
        content = f.read()

    content = handle_text(content).strip()
    if file_name == 'demo/demo_1.html':
        assert content == """博天环境\n在北京时间11月21日09:35分盘口异动快照：\n11月21日，博天环境\n盘中快速反弹，5分钟内涨幅超过2%，截至9点35分，报8.82元，成交780.54万元，换手率0.38%。"""

    elif file_name == 'demo/demo_2.html':
        assert content == """澳洋顺昌发布了关于深圳证券交易所问询函的回复。\n公告显示，江苏澳洋顺昌股份有限公司近日收到深圳证券交易所发来的《关于对江苏澳洋顺昌股份有限公司的问询函》，相关问询事项回复如下：\n一、本次收购前，公司控股江苏绿伟，持有其47.06%的股权。需要结合公司主营业务开展情况、未来发展计划和标的公司经营情况等详细说明公司收购标的公司少数股权的背景、原因、合理性及必要性。\n回复：首先，公司作为金属物流配送行业龙头企业，主要业务范围覆盖长三角及珠三角地区，凭借着规模化的运营、精细化的管理体制及专业的服务，公司在金属物流行业得到客户的普遍认可，作为规模化企业在金属物流配送市场中具有领先优势与竞争力。\n其次，公司自2011年进入LED行业，目前是国内LED芯片主要供应商之一，LED外延及芯片产能居国内同行业“前三强”。LED外延及芯片行业为资本和技术双密集型行业，公司以先进成熟的技术工艺为基础，结合业内领先的核心装备和公司优秀的管理理念，成为LED外延芯片行业技术水平、营运效率、盈利最好的企业之一，公司LED芯片凭借稳定的性能和高性价比获得市场的高度认可。\n以及公司自2016年通过收购江苏绿伟47.06%股权，进入锂电池行业。锂电池业务方面，天鹏电源在三元材料动力型圆柱电池领域具有10多年的研发和制造经验的积累，是国内高端工具类锂电池主要供应商，获得了欧美主流品牌和渠道客户信任和青睐。天鹏电源装备先进，具有200PPM的全自动生产线，效率与品质控制水平达到三元圆柱细分领域全球先进水平。自2013年开始，天鹏电源开始进入汽车动力锂电池的研发与制造，并顺利进入工信部汽车动力蓄电池行业规范目录。公司不断加大研发投入，研发团队持续扩充，研发实力得到了大幅提升，取得了多项发明及实用新型专利授权，具备量产NCA、NCM811、硅炭负极等新产品能力。\n标的公司江苏绿伟的全资子公司天鹏电源是高新技术企业，在三元材料动力型圆柱电池领域具有10多年的研发和制造经验的积累，拥有目前国内外顶尖水平圆柱型锂电池自动化产线，具有较大规模的圆柱型动力锂离子电池生产能力，在工具型动力锂电池领域处于领先地位。自2013年开始，天鹏电源开始进入汽车动力锂电池的研发与制造。锂电池产品主要应用于电动车辆及电动工具等领域，下游客户主要为电动车辆制造厂商及动力工具制造厂商。天鹏电源“动力锂电池智能制造装配车间”入选江苏省经济和信息化委员会、江苏省财政厅共同认定的2018年“江苏省示范智能车间”，这也是天鹏电源继“化成分容自动化生产车间”在2017年获评省级示范智能车间后第二个被授牌的智能车间。\n随着国际领先的设备设施的逐步投入，公司锂电池产品一致性和高可靠性得到进一步提高。公司根据国际客户严格的系统和可靠性要求，构建了全制程所有关键工序的在线检测和追溯系统，产品竞争力不断增强，已通过了数家顶级国际电动工具厂商的审核，初步开始批量供货导入。\n电动汽车市场方面，公司保持积极开发的策略，利用NCA产品技术优势，进一步开发了如上汽通用五菱、吉利知豆等新客户，有选择的开始供货。同时，公司也关注到二轮车市场的潜力，开始进行市场开拓并取得了阶段性的进展。\n2016年度、2017年度及2018年度，标的公司营业收入分别为3.54亿元、6.79亿元和9.91亿元，净利润分别为0.62亿元、1.85亿元和1.50亿元，整体经营业绩情况良好，处于稳步发展态势。\n公司多年来专注于三元圆柱动力锂电池的生产，积极布局三元高镍和硅碳体系研发，在电动工具领域的技术及市场沉淀丰富。江苏绿伟全资子公司天鹏电源在国内率先量产NCA三元圆柱动力锂电池，在高镍NCA产品储备上，公司已经完成18650型号3.5AH产品的技术储备。除18650型号产品技术提升外，公司已经完成21700型号锂电池技术储备，并着手规划21700产线的建设。公司稳步扩充产能，2018年度，公司建设中的两条18650生产线，其中一条已建设完成，另一条预计将于2019年建成。\n资本邦获悉，江苏澳洋顺昌股份有限公司是一家横跨金属物流配送、LED芯片、新能源锂电三大领域，营业收入近35亿元人民币的公司，拥有12家控股子公司遍布于张家港、上海、东莞、淮安、扬州地区，客户遍布海内外。"""

    elif file_name == 'demo/demo_3.html':
        assert content == """截至发稿，江铃汽车（000550）重挫9.98%，报27.95元，成交额17657万元，换手率1.21%，振幅4.99%，量比1.44。\n江铃汽车所在的汽车整车行业，整体跌幅为0.35%。领涨股为一汽轿车（000800）,领跌股为江铃汽车（000550）。\n资金方面，江铃汽车近5日共流入6070.39万元，今日到此时主力资金总体呈净流出状态，净流出8.45万元。\n该股最近一个交易日（2019年04月12日）融资融券数据为：融资余额18950.86万元，融券余额393.09万股，融资买入5450.59万元，融资净买入4006.51万元。\n最新的2018年年报显示，公司实现营业收入282.49亿元，净利润9,183.33万元，每股收益0.11元，市盈率291.86。\n机构评级方面，近半年内，3家券商给予买入建议。\n江铃汽车主营业务为全顺和N系列、T系列卡车及相关的汽车零部件、发动机、底盘及挂车的制造和销售。最新定期报告显示，该公司股东人数（户）为3.01万户，较上个报告期减少6.46%。"""

    elif file_name == 'demo/demo_4.html':
        assert content == """1月15日，东莞宏远工业区股份有限公司(证券代码：000573)股东广东宏远集团有限公司向东莞农村商业银行股份有限公司南城支行质押股份490万股，用于融资。\n本次质押股份490万股，占其所持公司股份的3.83%。质押开始日期为2019年1月14日。\n截至2019年1月14日，宏远集团持有公司股份1.28亿股，约占公司总股本的19.7%。其所持有上市公司股份累计被质押1.27亿股，占公司总股本比例约为19.56%。\n据挖贝网资料显示，粤宏远A是一家以房地产开发为主营业务，同时配套水电工程建设，以及经营工业区厂房租赁、原煤开采与销售，在循环经济中回收与利用铅蓄电池、含铅废物，生产环保再生铅的上市公司。"""

    elif file_name == 'demo/demo_5.html':
        assert content == """募集资金基本情况\n根据中国证券监督管理委员会下发的《关于核准浙江中欣氟材股份有限公司\n向高宝矿业有限公司等发行股份购买资产并募集配套资金的批复》（证监许可\n【2019】1393号），公司采用非公开发行股票的方式向特定投资者发行人民币普\n通股11,469,835股，每股发行价格23.54元，共募集资金人民币269,999,915.90\n元，扣除主承销商发行与承销费用含税金额后，余额人民币261,799,917.58元\n已由主承销商于汇入公司账户中。扣除公司已预付的发行与承销费用含税金额\n2,700,000.00元和其他发行费用9,774,971.56元后，净募集资金总额为人民币\n249,941,927.05 元（加回主承销商承销费和保荐费的可抵扣进项税额\n616,981.03元）。\n上述募集资金已经立信会计师事务所（特殊普通合伙）验证，并由其出具了\n信会师报字[2019]第10792号《验资报告》。\n为规范募集资金的管理和使用，保护投资者利益，根据相关法律法规的要求，公司为本次募集资金开设了专项账户，对募集资金采取专户储存管理，并与开户\n银行、保荐机构签订了《募集资金三方监管协议》，共同对募集资金的使用进行\n（二）自有资金预先投入募投项目及拟置换情况\n为保障公司发行股份及支付现金购买资产事项的顺利进行，公司以自有资金\n28,000.00万元预先投入募集资金投资项目（支付现金对价，含交易订金）。立\n信会计师事务所（特殊普通合伙）于2019年12月25日出具的信会师报字[2019]\n第ZF10808号《浙江中欣氟材股份有限公司以募集资金置换本次发行股份及支付\n现金购买资产已支付现金对价（含交易订金）的鉴证报告》，截止2019年12月\n25日，公司已使用自筹资金支付本次交易现金对价（含交易订金）的金额为人\n民币28,000.00万元。\n截至本公告出具之日，本次募集资金投资项目、募集资金承诺投资金额及拟\n置换金额情况如下：\n金额单位：人民币元\n项目名称\n投资总额\n募集资金承\n诺投资金额\n截止披露日自\n有资金已投入\n拟置换金额\n支付现金对价\n（含交易订金）\n400,000,000\n400,000,000\n280,000,000\n249,941,927.05\n400,000,000\n400,000,000\n280,000,000"""
  
    elif file_name == 'demo/demo_6.html':
        assert content == """原标题北斗星通：商誉减值不是坏事 新能源车投资亏损会发布对策丨公司问答"""

    elif file_name == 'demo/demo_7.html':
        assert content == """妙可蓝多\n在北京时间5月27日10:13分盘口异动快照：\n5月27日，妙可蓝多\n盘中快速反弹，5分钟内涨幅超过2%，截至10点13分，报36.22元，成交9398.79万元，换手率0.63%。"""


def test_all_content():
    """
    每次上线前先测试运行，直到无断言抛出异常
    """
    html_list = ['demo/demo_{}.html'.format(str(i)) for i in range(1, 8)]
    for html in html_list:
        get_content(html)

    print('完全正确')

if __name__ == "__main__":
    test_all_content()
