/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.util.FileBasedLock;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;
import org.openstreetmap.osmosis.replication.common.ReplicationState;

public class ReplicationStateWriter
implements ChangeSink {
    private static final Logger LOG = Logger.getLogger(ReplicationStateWriter.class.getName());
    private static final String LOCK_FILE = "replicate.lock";
    private static final String STATE_FILE = "state.txt";
    private FileBasedLock fileLock;
    private boolean lockObtained;
    private PropertiesPersister statePersistor;
    private ReplicationState state;

    public ReplicationStateWriter(File workingDirectory) {
        this.fileLock = new FileBasedLock(new File(workingDirectory, LOCK_FILE));
        this.statePersistor = new PropertiesPersister(new File(workingDirectory, STATE_FILE));
    }

    public void initialize(Map<String, Object> metaData) {
        if (this.lockObtained) {
            throw new OsmosisRuntimeException("initialize has already been called");
        }
        this.fileLock.lock();
        this.lockObtained = true;
        if (!metaData.containsKey("replication.state")) {
            throw new OsmosisRuntimeException("No replication state has been provided in metadata key replication.state.");
        }
        this.state = (ReplicationState)metaData.get("replication.state");
        if (this.statePersistor.exists()) {
            this.state.load(this.statePersistor.loadMap());
            this.state.setSequenceNumber(this.state.getSequenceNumber() + 1L);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Replication sequence number is " + this.state.getSequenceNumber() + ".");
            }
        }
    }

    public void process(ChangeContainer change) {
        if (!this.lockObtained) {
            throw new OsmosisRuntimeException("initialize has not been called");
        }
        if (this.state.getSequenceNumber() == 0L) {
            throw new OsmosisRuntimeException("No changes can be included for replication sequence 0.");
        }
    }

    public void complete() {
        if (!this.lockObtained) {
            throw new OsmosisRuntimeException("initialize has not been called");
        }
        this.statePersistor.store(this.state.store());
        this.state = null;
        this.fileLock.unlock();
        this.lockObtained = false;
    }

    public void close() {
        this.state = null;
        this.fileLock.close();
        this.lockObtained = false;
    }
}

