/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.osmosis;

import crosby.binary.osmosis.OsmosisBinaryParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.osmbinary.file.BlockInputStream;
import org.openstreetmap.osmosis.osmbinary.file.BlockReaderAdapter;

public class OsmosisReader
implements RunnableSource {
    private Sink sink;
    InputStream input;
    OsmosisBinaryParser parser;

    public OsmosisReader(InputStream input) {
        if (input == null) {
            throw new Error("Null input");
        }
        this.input = input;
        this.parser = new OsmosisBinaryParser();
    }

    public void setSink(Sink sink) {
        this.sink = sink;
        this.parser.setSink(sink);
    }

    public void run() {
        try {
            this.sink.initialize(Collections.emptyMap());
            new BlockInputStream(this.input, (BlockReaderAdapter)this.parser).process();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to process PBF stream", (Throwable)e);
        }
        finally {
            this.sink.close();
        }
    }
}

