/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.impl.BaseXMLReader;
import org.openstreetmap.osmosis.xml.v0_6.impl.FastXmlParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FastXmlReader
extends BaseXMLReader
implements RunnableSource {
    private Sink sink;

    public FastXmlReader(File file, boolean enableDateParsing, CompressionMethod compressionMethod) {
        super(file, enableDateParsing, compressionMethod);
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void run() {
        try {
            this.sink.initialize(Collections.emptyMap());
            this.handleXML(null);
            this.sink.complete();
        }
        finally {
            this.sink.close();
        }
    }

    @Override
    protected void parseXML(InputStream stream, DefaultHandler handler) throws SAXException, IOException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", false);
            factory.setProperty("javax.xml.stream.isNamespaceAware", false);
            factory.setProperty("javax.xml.stream.isValidating", false);
            XMLStreamReader xpp = factory.createXMLStreamReader(stream);
            FastXmlParser parser = new FastXmlParser(this.sink, xpp, this.isEnableDateParsing());
            parser.readOsm();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }
}

