# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['opentps',
 'opentps.core',
 'opentps.core.config',
 'opentps.core.config.logger',
 'opentps.core.data',
 'opentps.core.data.CTCalibrations',
 'opentps.core.data.CTCalibrations.MCsquareCalibration',
 'opentps.core.data.CTCalibrations.RayStationCalibration',
 'opentps.core.data.MCsquare',
 'opentps.core.data.dynamicData',
 'opentps.core.data.images',
 'opentps.core.data.plan',
 'opentps.core.examples',
 'opentps.core.examples.dynamicData',
 'opentps.core.examples.imageProcessing',
 'opentps.core.examples.planOptimization',
 'opentps.core.examples.registration',
 'opentps.core.examples.segmentation',
 'opentps.core.io',
 'opentps.core.processing',
 'opentps.core.processing.C_libraries',
 'opentps.core.processing.deformableDataAugmentationToolBox',
 'opentps.core.processing.doseCalculation',
 'opentps.core.processing.doseCalculation.MCsquare',
 'opentps.core.processing.doseCalculation.MCsquare.BDL',
 'opentps.core.processing.doseCalculation.MCsquare.Materials',
 'opentps.core.processing.doseCalculation.MCsquare.Scanners',
 'opentps.core.processing.imageProcessing',
 'opentps.core.processing.imageSimulation',
 'opentps.core.processing.planDeliverySimulation',
 'opentps.core.processing.planEvaluation',
 'opentps.core.processing.planOptimization',
 'opentps.core.processing.planOptimization.acceleration',
 'opentps.core.processing.planOptimization.objectives',
 'opentps.core.processing.planOptimization.solvers',
 'opentps.core.processing.registration',
 'opentps.core.processing.segmentation',
 'opentps.core.processing.trackingToolBox',
 'opentps.core.utils']

package_data = \
{'': ['*'],
 'opentps.core.processing.doseCalculation.MCsquare.Materials': ['Adipose_Tissue/*',
                                                                'Air/*',
                                                                'Average_Soft_Tissue/*',
                                                                'Blood/*',
                                                                'Bone_Cortical/*',
                                                                'Bone_Spongiosa/*',
                                                                'Brain/*',
                                                                'Breast/*',
                                                                'CFRP/*',
                                                                'Cartilage/*',
                                                                'Eye_Lens/*',
                                                                'G10/*',
                                                                'Gammex_SB3_Bone/*',
                                                                'Gastrointestinal_Tract/*',
                                                                'Heart/*',
                                                                'Kidney/*',
                                                                'Lexan/*',
                                                                'Liver/*',
                                                                'Lung/*',
                                                                'Lymph/*',
                                                                'Marrow_Red/*',
                                                                'Marrow_Yellow/*',
                                                                'Muscle_Skeletal/*',
                                                                'Ovary/*',
                                                                'PMMA/*',
                                                                'Pancreas/*',
                                                                'Polystyrene/*',
                                                                'Polyurethane/*',
                                                                'Pyrex/*',
                                                                'RW3/*',
                                                                'Schneider_AT_AG_SI1/*',
                                                                'Schneider_AT_AG_SI2/*',
                                                                'Schneider_AT_AG_SI3/*',
                                                                'Schneider_AT_AG_SI4/*',
                                                                'Schneider_AT_AG_SI5/*',
                                                                'Schneider_Air/*',
                                                                'Schneider_ConnectiveTissue/*',
                                                                'Schneider_Lung/*',
                                                                'Schneider_Marrow_Bone01/*',
                                                                'Schneider_Marrow_Bone02/*',
                                                                'Schneider_Marrow_Bone03/*',
                                                                'Schneider_Marrow_Bone04/*',
                                                                'Schneider_Marrow_Bone05/*',
                                                                'Schneider_Marrow_Bone06/*',
                                                                'Schneider_Marrow_Bone07/*',
                                                                'Schneider_Marrow_Bone08/*',
                                                                'Schneider_Marrow_Bone09/*',
                                                                'Schneider_Marrow_Bone10/*',
                                                                'Schneider_Marrow_Bone11/*',
                                                                'Schneider_Marrow_Bone12/*',
                                                                'Schneider_Marrow_Bone13/*',
                                                                'Schneider_Marrow_Bone14/*',
                                                                'Schneider_Marrow_Bone15/*',
                                                                'Schneider_SoftTissus/*',
                                                                'Skin/*',
                                                                'Solid_water/*',
                                                                'Spleen/*',
                                                                'Testis/*',
                                                                'Thyroid/*',
                                                                'Water/*',
                                                                'aluminium/*',
                                                                'calcium/*',
                                                                'carbon/*',
                                                                'copper/*',
                                                                'hydrogen/*',
                                                                'iron/*',
                                                                'lead/*',
                                                                'nitrogen/*',
                                                                'oxygen/*',
                                                                'phosphorus/*',
                                                                'silicon/*',
                                                                'tungsten/*'],
 'opentps.core.processing.doseCalculation.MCsquare.Scanners': ['UCL_Toshiba/*'],
 'opentps.core.processing.registration': ['Morphons_kernels/*']}

install_requires = \
['Pillow>=9.2.0,<10.0.0',
 'SimpleITK>=2.1.1,<3.0.0',
 'numpy>=1.23.2,<2.0.0',
 'pandas>=1.4.3,<2.0.0',
 'pydicom>=2.3.0,<3.0.0',
 'setuptools>=61.0.0,<62.0.0',
 'sparse-dot-mkl>=0.8.2,<0.9.0']

setup_kwargs = {
    'name': 'opentps-core',
    'version': '1.0.6',
    'description': 'Open source TPS for advanced proton therapy',
    'long_description': "# opentps-core\n\nCore library of opentps, a Python application for treatment planning in proton therapy, based on the MCsquare Monte Carlo dose engine.\n\n\n## Installation (Linux):\nRequirements are listed in pyproject.toml.\nTo install all required dependencies:\n``` \npoetry install\n``` \n\nAdditional system libraries (Ubuntu 19 or more recent):\n``` \nsudo apt install libmkl-rt\n``` \n\nAdditional system libraries (Ubuntu 18):\n``` \ncd /tmp\nwget https://apt.repos.intel.com/intel-gpg-keys/GPG-PUB-KEY-INTEL-SW-PRODUCTS-2019.PUB\napt-key add GPG-PUB-KEY-INTEL-SW-PRODUCTS-2019.PUB\nsudo sh -c 'echo deb https://apt.repos.intel.com/mkl all main > /etc/apt/sources.list.d/intel-mkl.list'\nsudo apt-get update\nsudo apt-get install intel-mkl-64bit-2020.1-102\necho 'export LD_LIBRARY_PATH=/opt/intel/mkl/lib/intel64:$LD_LIBRARY_PATH' | sudo tee -a /etc/profile.d/mkl_lib.sh\n\n# adapted from: http://dirk.eddelbuettel.com/blog/2018/04/15/\n```\n\nOptional python modules:\n``` \npip3 install --user tensorflow\npip3 install --user keras\npip3 install --user cupy\n```\n\n## Installation (Windows):\nNote: VTK is only compatible with Python version <= 3.9. Do not use Python 3.10\n\n1) Install anaconda on your Windows computer\n\n2) Open Anaconda Prompt (via the Anaconda application)\n\n3) Create a new Anaconda environment:\n``` \nconda create --name OpenTPS python=3.8\n``` \n\n4) Activate the new environment:\n``` \nconda activate OpenTPS\n``` \n\n5) Install the following python modules:\nPython modules:\n``` \npip3 install --upgrade --user pip\npip3 install --user pydicom\npip3 install --user numpy\npip3 install --user scipy\npip3 install --user matplotlib\npip3 install --user Pillow\npip3 install --user sparse_dot_mkl\npip3 install --user SimpleITK\npip3 install --user pandas\npip3\n```\n\nOptional python modules:\n``` \npip3 install --user tensorflow\npip3 install --user keras\npip3 install --user cupy\n```\n",
    'author': 'Sylvain Deffet',
    'author_email': 'sylvaindeffet@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://opentps.org/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
